/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.command;

import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.lushplugins.pvptoggle.PvPToggle;
import org.lushplugins.pvptoggle.data.CooldownManager;
import org.lushplugins.pvptoggle.libraries.lushlib.libraries.chatcolor.ChatColorHandler;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.Optional;
import revxrsal.commands.annotation.Subcommand;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;

@Command(value={"pvp"})
public class ToggleCommand {
    private final HashSet<UUID> processing = new HashSet();

    public String toggle(BukkitCommandActor actor, boolean newState, @Optional Player target) {
        int timeTillExecute;
        if (target != null) {
            if (!actor.sender().hasPermission("pvptoggle.admin.others")) {
                return PvPToggle.getInstance().getConfigManager().getMessage("no-permission");
            }
            timeTillExecute = 0;
        } else {
            target = actor.requirePlayer();
            if (!target.hasPermission("pvptoggle.bypasscooldown")) {
                if (this.processing.contains(target.getUniqueId())) {
                    return PvPToggle.getInstance().getConfigManager().getMessage("command-running");
                }
                long cooldown = PvPToggle.getInstance().getCooldownManager().getCooldown(target);
                if (cooldown >= 0L) {
                    return PvPToggle.getInstance().getConfigManager().getMessage("pvp-cooldown").replace("%seconds%", String.valueOf(cooldown));
                }
                timeTillExecute = PvPToggle.getInstance().getConfigManager().getCommandWaitTime();
            } else {
                timeTillExecute = 0;
            }
        }
        UUID targetUUID = target.getUniqueId();
        if (timeTillExecute > 0) {
            this.processing.add(targetUUID);
            ChatColorHandler.sendMessage((CommandSender)target, PvPToggle.getInstance().getConfigManager().getMessage("command-timer").replace("%seconds%", String.valueOf(timeTillExecute)));
        }
        Player finalTarget = target;
        Bukkit.getScheduler().runTaskLater((Plugin)PvPToggle.getInstance(), () -> {
            PvPToggle.getInstance().getDataManager().getPvPUser(finalTarget).setPvPEnabled(newState);
            PvPToggle.getInstance().getCooldownManager().setCooldown(finalTarget, CooldownManager.CooldownType.COMMAND);
            this.processing.remove(targetUUID);
            if (newState) {
                PvPToggle.getInstance().getConfigManager().sendMessage((CommandSender)finalTarget, "pvp-state-enabled");
            } else {
                PvPToggle.getInstance().getConfigManager().sendMessage((CommandSender)finalTarget, "pvp-state-disabled");
            }
            if (actor.asPlayer() != finalTarget) {
                ChatColorHandler.sendMessage(actor.sender(), PvPToggle.getInstance().getConfigManager().getMessage("pvp-state-changed-other").replace("%player%", finalTarget.getName()).replace("%pvp_state%", String.valueOf(newState)));
            }
        }, (long)timeTillExecute * 20L);
        return null;
    }

    @Subcommand(value={"toggle"})
    public String toggle(BukkitCommandActor actor, @Optional Player target) {
        boolean newState = !PvPToggle.getInstance().getDataManager().getPvPUser(target != null ? target : actor.requirePlayer()).isPvPEnabled();
        return this.toggle(actor, newState, target);
    }

    @Subcommand(value={"on"})
    public String on(BukkitCommandActor actor, @Optional Player target) {
        return this.toggle(actor, true, target);
    }

    @Subcommand(value={"off"})
    public String off(BukkitCommandActor actor, @Optional Player target) {
        return this.toggle(actor, false, target);
    }
}

