/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.data;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.lushplugins.pvptoggle.PvPToggle;

public class CooldownManager {
    public final HashMap<UUID, Long> commandCooldown = new HashMap();
    public final HashMap<UUID, Long> pvpCooldown = new HashMap();

    @Deprecated
    public void setCooldown(Player player, String cooldownType) {
        this.setCooldown(player, CooldownType.valueOf(cooldownType.toUpperCase()));
    }

    public void setCooldown(Player player, CooldownType cooldownType) {
        switch (cooldownType.ordinal()) {
            case 1: {
                this.commandCooldown.put(player.getUniqueId(), LocalDateTime.now().toEpochSecond(ZoneOffset.UTC));
                break;
            }
            case 2: {
                this.pvpCooldown.put(player.getUniqueId(), LocalDateTime.now().toEpochSecond(ZoneOffset.UTC));
                break;
            }
            case 0: {
                this.commandCooldown.put(player.getUniqueId(), LocalDateTime.now().toEpochSecond(ZoneOffset.UTC));
                this.pvpCooldown.put(player.getUniqueId(), LocalDateTime.now().toEpochSecond(ZoneOffset.UTC));
            }
        }
    }

    @Deprecated
    public void removeCooldown(Player player, String cooldownType) {
        this.removeCooldown(player, CooldownType.valueOf(cooldownType.toUpperCase()));
    }

    public void removeCooldown(Player player, CooldownType cooldownType) {
        switch (cooldownType.ordinal()) {
            case 1: {
                this.commandCooldown.remove(player.getUniqueId(), LocalDateTime.now().toEpochSecond(ZoneOffset.UTC));
                break;
            }
            case 2: {
                this.pvpCooldown.remove(player.getUniqueId(), LocalDateTime.now().toEpochSecond(ZoneOffset.UTC));
                break;
            }
            case 0: {
                this.commandCooldown.remove(player.getUniqueId(), LocalDateTime.now().toEpochSecond(ZoneOffset.UTC));
                this.pvpCooldown.remove(player.getUniqueId(), LocalDateTime.now().toEpochSecond(ZoneOffset.UTC));
            }
        }
    }

    public long getCooldown(Player player) {
        long commandCooldown = this.getCooldown(player, CooldownType.COMMAND);
        long pvpCooldown = this.getCooldown(player, CooldownType.PVP);
        return Math.max(commandCooldown, pvpCooldown);
    }

    @Deprecated
    public long getCooldown(Player player, String cooldownType) {
        return this.getCooldown(player, CooldownType.valueOf(cooldownType.toUpperCase()));
    }

    public long getCooldown(Player player, CooldownType cooldownType) {
        if (player.hasPermission("pvptoggle.bypasscooldown")) {
            return -1L;
        }
        HashMap<UUID, Long> cooldownCheck = null;
        switch (cooldownType.ordinal()) {
            case 1: {
                cooldownCheck = this.commandCooldown;
                break;
            }
            case 2: {
                cooldownCheck = this.pvpCooldown;
            }
        }
        if (cooldownCheck == null) {
            return -1L;
        }
        UUID playerUUID = player.getUniqueId();
        if (!cooldownCheck.containsKey(playerUUID)) {
            return -1L;
        }
        long startTime = cooldownCheck.get(playerUUID);
        long currentTime = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);
        long seconds = currentTime - startTime;
        switch (cooldownType.ordinal()) {
            case 1: {
                if (seconds >= PvPToggle.getInstance().getConfigManager().getCommandCooldown()) {
                    this.removeCooldown(player, cooldownType);
                    return -1L;
                }
                return PvPToggle.getInstance().getConfigManager().getCommandCooldown() - seconds;
            }
            case 2: {
                if (seconds >= PvPToggle.getInstance().getConfigManager().getPvPCooldown()) {
                    this.removeCooldown(player, cooldownType);
                    return -1L;
                }
                return PvPToggle.getInstance().getConfigManager().getPvPCooldown() - seconds;
            }
        }
        return seconds;
    }

    public static enum CooldownType {
        ALL,
        COMMAND,
        PVP;

    }
}

