/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.placeholderhandler.util;

import java.util.Objects;
import org.jetbrains.annotations.Contract;

public final class Preconditions {
    private Preconditions() {
        Preconditions.cannotInstantiate(Preconditions.class);
    }

    public static <T> void notEmpty(T[] array, String errorMessage) {
        if (array.length == 0) {
            throw new IllegalStateException(errorMessage);
        }
    }

    @Contract(value="null, _ -> fail; !null, _ -> param1")
    public static <T> T notNull(T t, String err) {
        return Objects.requireNonNull(t, err + " cannot be null!");
    }

    @Contract(value="_ -> fail")
    public static void cannotInstantiate(Class<?> clazz) {
        throw new UnsupportedOperationException("Cannot instantiate " + String.valueOf(clazz) + "!");
    }
}

