/*
 * Decompiled with CFR 0.152.
 */
package org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform;

import java.util.HashMap;
import java.util.concurrent.Callable;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.PlatformData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.github.GithubData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.github.GithubVersionChecker;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.hangar.HangarData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.hangar.HangarVersionChecker;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.modrinth.ModrinthData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.modrinth.ModrinthVersionChecker;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.spigot.SpigotData;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.platform.spigot.SpigotVersionChecker;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.util.Pair;
import org.lushplugins.pvptoggle.libraries.pluginupdater.api.version.VersionChecker;

public class PlatformRegistry {
    private static final HashMap<String, Pair<Callable<VersionChecker>, PlatformDataConstructor>> platformConstructors = new HashMap();
    private static final HashMap<String, VersionChecker> cachedPlatforms = new HashMap();

    @Nullable
    public static VersionChecker getVersionChecker(String platform) {
        return PlatformRegistry.getOrConstructVersionChecker(platform);
    }

    @Nullable
    public static PlatformData getPlatformData(String platform, ConfigurationSection configurationSection) {
        try {
            return platformConstructors.containsKey(platform) ? platformConstructors.get(platform).second().apply(configurationSection) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void register(@NotNull String platform, @NotNull Callable<VersionChecker> updater, @NotNull PlatformDataConstructor platformDataConstructor) {
        if (platformConstructors.containsKey(platform)) {
            throw new IllegalStateException("This platform is already registered");
        }
        platformConstructors.put(platform, new Pair<Callable<VersionChecker>, PlatformDataConstructor>(updater, platformDataConstructor));
    }

    public static void unregister(String platform) {
        platformConstructors.remove(platform);
    }

    @Nullable
    private static VersionChecker getOrConstructVersionChecker(@NotNull String platform) {
        if (cachedPlatforms.containsKey(platform)) {
            return cachedPlatforms.get(platform);
        }
        if (platformConstructors.containsKey(platform)) {
            try {
                VersionChecker versionChecker = platformConstructors.get(platform).first().call();
                cachedPlatforms.put(platform, versionChecker);
                return versionChecker;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    static {
        PlatformRegistry.register("github", GithubVersionChecker::new, GithubData::new);
        PlatformRegistry.register("hangar", HangarVersionChecker::new, HangarData::new);
        PlatformRegistry.register("modrinth", ModrinthVersionChecker::new, ModrinthData::new);
        PlatformRegistry.register("spigot", SpigotVersionChecker::new, SpigotData::new);
    }

    @FunctionalInterface
    public static interface PlatformDataConstructor {
        public PlatformData apply(ConfigurationSection var1);
    }
}

