/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import pt.gif.cave_dweller.common.CaveDweller;
import pt.gif.cave_dweller.common.network.CaveSound;

public class ClientPayloadHandler {
    public static void handleDataOnMain(CaveSound packet, IPayloadContext context) {
        Registry soundEvents = BuiltInRegistries.SOUND_EVENT;
        if (soundEvents == null) {
            CaveDweller.LOGGER.error("Minecraft Sound registry was null while handling packet");
            return;
        }
        SoundEvent soundEvent = (SoundEvent)soundEvents.get(packet.soundResource());
        if (soundEvent == null) {
            CaveDweller.LOGGER.error("Sound Event [{}] was null while handling packet", (Object)packet.soundResource());
            return;
        }
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance(soundEvent, SoundSource.AMBIENT, 2.0f, 1.0f, RandomSource.create(), packet.playerPosition()));
    }
}

