/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.client.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import pt.gif.cave_dweller.client.entities.CaveDwellerModel;
import pt.gif.cave_dweller.client.entities.layer.CaveDwellerEyesLayer;
import pt.gif.cave_dweller.core.util.Utils;
import pt.gif.cave_dweller.server.entities.CaveDwellerEntity;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class CaveDwellerRenderer
extends GeoEntityRenderer<CaveDwellerEntity> {
    public CaveDwellerRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new CaveDwellerModel());
        this.shadowRadius = 0.3f;
        this.addRenderLayer(new CaveDwellerEyesLayer((GeoRenderer<CaveDwellerEntity>)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull CaveDwellerEntity instance) {
        return ResourceLocation.fromNamespaceAndPath((String)"cave_dweller", (String)("textures/entity/cave_dweller_texture" + Utils.getTextureAppend() + ".png"));
    }

    public void render(CaveDwellerEntity entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        if (entity.isBaby()) {
            poseStack.scale(0.1f, 0.1f, 0.1f);
        } else {
            poseStack.scale(1.3f, 1.3f, 1.3f);
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.popPose();
    }
}

