/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.common;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;
import pt.gif.cave_dweller.client.entities.CaveDwellerRenderer;
import pt.gif.cave_dweller.common.network.CaveSound;
import pt.gif.cave_dweller.common.registry.ModEntityTypes;
import pt.gif.cave_dweller.common.registry.ModSounds;
import pt.gif.cave_dweller.core.timer.Timer;
import pt.gif.cave_dweller.core.util.Utils;
import pt.gif.cave_dweller.server.config.ServerConfig;
import pt.gif.cave_dweller.server.entities.CaveDwellerEntity;

@Mod(value="cave_dweller")
public class CaveDweller {
    public static final String MOD_ID = "cave_dweller";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Random RANDOM = new Random();
    private static final HashMap<String, Timer> TIMERS = new HashMap();
    public static boolean RELOAD_ALL = false;
    public static boolean RELOAD_MISSING = false;

    public CaveDweller(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        ModEntityTypes.register(modEventBus);
        ModSounds.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
    }

    @SubscribeEvent
    public void serverStartup(ServerStartedEvent event) {
        RELOAD_ALL = true;
    }

    @SubscribeEvent
    public void serverTick(ServerTickEvent.Pre event) {
        String key;
        if (RELOAD_ALL) {
            TIMERS.clear();
            RELOAD_ALL = false;
        }
        Iterable levels = event.getServer().getAllLevels();
        if (TIMERS.isEmpty()) {
            for (ServerLevel level : levels) {
                key = level.dimension().location().toString();
                isRelevant = ((List)ServerConfig.DIMENSION_WHITELIST.get()).contains(key);
                if (!isRelevant) continue;
                TIMERS.put(key, new Timer());
            }
            if (TIMERS.isEmpty() && event.getServer().getTickCount() % 6000 == 0) {
                LOGGER.debug("There are currently no timers present - are the dimensions properly configured?");
            }
            RELOAD_ALL = false;
            RELOAD_MISSING = false;
        } else if (RELOAD_MISSING) {
            for (ServerLevel level : levels) {
                key = level.dimension().location().toString();
                isRelevant = TIMERS.get(key) == null && ((List)ServerConfig.DIMENSION_WHITELIST.get()).contains(key);
                if (!isRelevant) continue;
                TIMERS.put(key, new Timer());
            }
            RELOAD_MISSING = false;
        }
        for (ServerLevel level : levels) {
            key = level.dimension().location().toString();
            if (TIMERS.get(key) == null) continue;
            this.handleLogic(level);
        }
    }

    private void handleLogic(ServerLevel level) {
        if (level == null) {
            return;
        }
        List players = level.getPlayers(this::isRelevantPlayer);
        if (players.isEmpty()) {
            return;
        }
        String key = level.dimension().location().toString();
        Timer timer = TIMERS.get(key);
        if (timer.currentVictim == null || players.stream().filter(element -> element.getStringUUID().equals(timer.currentVictim.getStringUUID())).toList().isEmpty()) {
            timer.currentVictim = (Entity)players.get(RANDOM.nextInt(players.size()));
        }
        Iterable entities = level.getAllEntities();
        AtomicInteger caveDwellerCount = new AtomicInteger();
        entities.forEach(entity -> {
            if (entity instanceof CaveDwellerEntity) {
                caveDwellerCount.getAndAdd(1);
            }
        });
        ++timer.currentSpawn;
        ++timer.currentNoise;
        if (timer.isNoiseTimerReached() && (caveDwellerCount.get() > 0 || timer.currentSpawn >= Utils.secondsToTicks((Integer)ServerConfig.CAN_SPAWN_MAX.get()) / 2)) {
            this.playCaveSoundToSpelunkers(players, timer);
        }
        if (timer.isSpawnTimerReached() && caveDwellerCount.get() < (Integer)ServerConfig.MAXIMUM_AMOUNT.get() && RANDOM.nextDouble() <= (Double)ServerConfig.SPAWN_CHANCE_PER_TICK.get() && timer.currentVictim != null) {
            Optional<CaveDwellerEntity> optionalEntity = Utils.trySpawnMob(timer.currentVictim, ModEntityTypes.CAVE_DWELLER.get(), MobSpawnType.TRIGGERED, level, timer.currentVictim.blockPosition(), 40, 35, 6, SpawnUtil.Strategy.ON_TOP_OF_COLLIDER);
            if (optionalEntity.isPresent()) {
                this.playCaveSoundToSpelunkers(players, timer);
                CaveDwellerEntity caveDweller = optionalEntity.get();
                caveDweller.setInvisible(true);
                caveDweller.hasSpawned = true;
                timer.resetSpawnTimer();
            } else {
                timer.currentVictim = null;
            }
        }
    }

    private void playCaveSoundToSpelunkers(List<ServerPlayer> players, Timer timer) {
        Entity currentVictim = timer.currentVictim;
        if (currentVictim == null) {
            return;
        }
        players.forEach(player -> {
            ResourceLocation soundLocation;
            switch (RANDOM.nextInt(4)) {
                case 1: {
                    ResourceLocation resourceLocation = ModSounds.CAVENOISE_2.get().getLocation();
                    break;
                }
                case 2: {
                    ResourceLocation resourceLocation = ModSounds.CAVENOISE_3.get().getLocation();
                    break;
                }
                case 3: {
                    ResourceLocation resourceLocation = ModSounds.CAVENOISE_4.get().getLocation();
                    break;
                }
                default: {
                    ResourceLocation resourceLocation = soundLocation = ModSounds.CAVENOISE_1.get().getLocation();
                }
            }
            if (!((Boolean)ServerConfig.ONLY_PLAY_NOISE_TO_TARGET.get()).booleanValue() || player.is(timer.currentVictim)) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new CaveSound(soundLocation, currentVictim.blockPosition(), 2.0f, 1.0f), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
        timer.resetNoiseTimer();
    }

    private boolean isRelevantPlayer(ServerPlayer player) {
        if (!Utils.isValidTarget((Entity)player)) {
            return false;
        }
        if (player.position().y > (double)((Integer)ServerConfig.SPAWN_HEIGHT.get()).intValue()) {
            return false;
        }
        ServerLevel serverLevel = player.serverLevel();
        int actualSkyLightLevel = serverLevel.getBrightness(LightLayer.SKY, player.blockPosition()) - serverLevel.getSkyDarken();
        float sunAngle = serverLevel.getSunAngle(1.0f);
        if (actualSkyLightLevel > 0) {
            float f1 = sunAngle < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            sunAngle += (f1 - sunAngle) * 0.2f;
            actualSkyLightLevel = Math.round((float)actualSkyLightLevel * Mth.cos((float)sunAngle));
        }
        if ((actualSkyLightLevel = Mth.clamp((int)actualSkyLightLevel, (int)0, (int)15)) > (Integer)ServerConfig.SKY_LIGHT_LEVEL.get()) {
            return false;
        }
        LayerLightEventListener blockLighting = player.serverLevel().getLightEngine().getLayerListener(LightLayer.BLOCK);
        if (blockLighting.getLightValue(player.blockPosition()) > (Integer)ServerConfig.BLOCK_LIGHT_LEVEL.get()) {
            return false;
        }
        boolean isOnSurface = Utils.isOnSurface((Entity)player);
        if (isOnSurface) {
            if (!((Boolean)ServerConfig.ALLOW_SURFACE_SPAWN.get()).booleanValue()) {
                return false;
            }
            return ServerConfig.isInValidBiome((Entity)player);
        }
        return true;
    }

    public static boolean speedUpTimers(String key, int spawnDelta, int noiseDelta) {
        Timer timer = TIMERS.get(key);
        LOGGER.debug("Speeding up timers for the dimension [{}], timer: [{}]", (Object)key, (Object)timer);
        if (timer != null) {
            timer.currentSpawn += spawnDelta;
            timer.currentNoise += noiseDelta;
            return true;
        }
        return false;
    }

    public static Pair<Integer, Integer> getTimer(String key, String type) {
        Timer timer = TIMERS.get(key);
        int current = -1;
        int target = -1;
        if (timer != null) {
            switch (type) {
                case "spawn": {
                    current = timer.currentSpawn;
                    target = timer.targetSpawn;
                    break;
                }
                case "noise": {
                    current = timer.currentNoise;
                    target = timer.targetNoise;
                }
            }
        }
        return Pair.of((Object)current, (Object)target);
    }

    @Nullable
    public static Entity getCurrentVictim(String key) {
        Timer timer = TIMERS.get(key);
        if (timer != null) {
            return timer.currentVictim;
        }
        return null;
    }

    @EventBusSubscriber(modid="cave_dweller", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(ModEntityTypes.CAVE_DWELLER.get(), CaveDwellerRenderer::new);
        }
    }
}

