/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.common.events;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import pt.gif.cave_dweller.common.CaveDweller;
import pt.gif.cave_dweller.core.path.PathUtil;

@EventBusSubscriber(modid="cave_dweller")
public class NeoForgeEvents {
    @SubscribeEvent
    public static void registerEvents(RegisterCommandsEvent event) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"cave_dweller").requires(source -> source.hasPermission(2));
        builder.then(Commands.literal((String)"fast_forward").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"spawn_delta_ticks", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"noise_delta_ticks", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int noiseDelta;
            int spawnDelta;
            String dimension = DimensionArgument.getDimension((CommandContext)context, (String)"dimension").dimension().location().toString();
            boolean wasSuccessful = CaveDweller.speedUpTimers(dimension, spawnDelta = IntegerArgumentType.getInteger((CommandContext)context, (String)"spawn_delta_ticks"), noiseDelta = IntegerArgumentType.getInteger((CommandContext)context, (String)"noise_delta_ticks"));
            if (wasSuccessful) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Timer has been successfully changed"), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Timer for dimension [" + dimension + "] does not exist")));
            }
            return 1;
        })))));
        builder.then(Commands.literal((String)"get_target").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(context -> {
            String dimension = DimensionArgument.getDimension((CommandContext)context, (String)"dimension").dimension().location().toString();
            Entity currentVictim = CaveDweller.getCurrentVictim(dimension);
            if (currentVictim != null) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)currentVictim.toString()), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Timer for dimension [" + dimension + "] does not exist or has no target")));
            }
            return 1;
        })));
        builder.then(Commands.literal((String)"get_timer").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.string()).suggests((context, suggestionsBuilder) -> SharedSuggestionProvider.suggest((String[])new String[]{"spawn", "noise"}, (SuggestionsBuilder)suggestionsBuilder)).executes(context -> {
            String type;
            String dimension = DimensionArgument.getDimension((CommandContext)context, (String)"dimension").dimension().location().toString();
            Pair<Integer, Integer> timer = CaveDweller.getTimer(dimension, type = StringArgumentType.getString((CommandContext)context, (String)"type"));
            if ((Integer)timer.getFirst() != -1 && (Integer)timer.getSecond() != -1) {
                double currentSeconds = (double)((Integer)timer.getFirst()).intValue() / 20.0;
                double targetSeconds = (double)((Integer)timer.getSecond()).intValue() / 20.0;
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(currentSeconds + " / " + targetSeconds + " seconds")), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Timer for dimension [" + dimension + "] does not exist")));
            }
            return 1;
        }))));
        builder.then(Commands.literal((String)"dev").then(Commands.literal((String)"get_depth").then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(context -> {
            String dimension = DimensionArgument.getDimension((CommandContext)context, (String)"dimension").dimension().location().toString();
            Entity victim = CaveDweller.getCurrentVictim(dimension);
            if (victim == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Something went wrong! Couldn't find target."));
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Player dist to the ground: " + PathUtil.distToCollider(victim, PathUtil.getEntityVec(victim)))), true);
            }
            return 1;
        }))));
        builder.then(Commands.literal((String)"dev").then(Commands.literal((String)"get_valid_pos").then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"y", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int x = IntegerArgumentType.getInteger((CommandContext)context, (String)"x");
            int y = IntegerArgumentType.getInteger((CommandContext)context, (String)"y");
            int z = IntegerArgumentType.getInteger((CommandContext)context, (String)"z");
            BlockPos blockPos = new BlockPos(x, y, z);
            Entity executor = ((CommandSourceStack)context.getSource()).getEntity();
            if (executor != null) {
                BlockPos validPos = PathUtil.validPos(executor, blockPos, 1, 1);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Closest valid pos at: " + String.valueOf(validPos))), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Something went wrong!"));
            }
            return 1;
        }))))));
        event.getDispatcher().register(builder);
    }
}

