/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.common.mixins;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import pt.gif.cave_dweller.server.entities.CaveDwellerEntity;

@Mixin(value={PathNavigation.class})
public abstract class MixinPathNavigation {
    @Unique
    private boolean cave_dweller$wasCrawling;
    @Shadow
    @Final
    protected Mob mob;

    @Inject(method={"createPath(Ljava/util/Set;IZIF)Lnet/minecraft/world/level/pathfinder/Path;"}, at={@At(value="HEAD")})
    public void setCrawling_true(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange, CallbackInfoReturnable<Path> callback) {
        Mob mob = this.mob;
        if (mob instanceof CaveDwellerEntity) {
            CaveDwellerEntity caveDweller = (CaveDwellerEntity)mob;
            this.cave_dweller$wasCrawling = caveDweller.isCrawling();
            caveDweller.setCrawling(true);
        }
    }

    @Inject(method={"createPath(Ljava/util/Set;IZIF)Lnet/minecraft/world/level/pathfinder/Path;"}, at={@At(value="RETURN")})
    public void setCrawling_false(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange, CallbackInfoReturnable<Path> callback) {
        Mob mob = this.mob;
        if (mob instanceof CaveDwellerEntity) {
            CaveDwellerEntity caveDweller = (CaveDwellerEntity)mob;
            caveDweller.setCrawling(this.cave_dweller$wasCrawling);
        }
    }
}

