/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.core.path;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class PathUtil {
    public static Path pathComposite(Entity entity, Path path) {
        Path compPath = PathUtil.fixInvalidNodes(entity, path);
        return PathUtil.fixFarawayNodes(entity, compPath);
    }

    public static Path fixFarawayNodes(Entity entity, Path path) {
        ArrayList<Node> fixedPath = new ArrayList<Node>();
        if (path == null || path.getNodeCount() <= 0) {
            return null;
        }
        fixedPath.add(path.getNode(0));
        for (int i = 1; i < path.getNodeCount(); ++i) {
            Node lastNode = path.getNode(i - 1);
            Node currentNode = path.getNode(i);
            int heightDist = PathUtil.valDifference(currentNode.y, lastNode.y);
            if (heightDist > 3) {
                Node newNode = PathUtil.reallocateNode(entity, lastNode, path.getTarget(), 2, 1);
                fixedPath.add(Objects.requireNonNullElse(newNode, currentNode));
                continue;
            }
            fixedPath.add(currentNode);
        }
        return new Path(fixedPath, path.getTarget(), path.canReach());
    }

    public static Path fixInvalidNodes(Entity entity, Path path) {
        ArrayList<Node> fixedPath = new ArrayList<Node>();
        for (int i = 0; i < path.getNodeCount(); ++i) {
            BlockPos nodePos = path.getNode(i).asBlockPos();
            if (entity.level().getBlockState(nodePos.below()).isAir()) {
                Node newNode = PathUtil.reallocateNode(entity, path.getNode(i), path.getTarget(), 1, 1);
                fixedPath.add(Objects.requireNonNullElse(newNode, path.getNode(i)));
                continue;
            }
            fixedPath.add(path.getNode(i));
        }
        return new Path(fixedPath, path.getTarget(), path.canReach());
    }

    public static Node reallocateNode(Entity entity, Node node, BlockPos target, int searchRadius) {
        BlockPos validNodePos = PathUtil.validNodePos(entity, node, target, searchRadius, 0);
        if (validNodePos != null) {
            return new Node(validNodePos.getX(), validNodePos.getY(), validNodePos.getZ());
        }
        return null;
    }

    public static Node reallocateNode(Entity entity, Node node, BlockPos target, int xzSearchRadius, int ySearchRadius) {
        BlockPos validNodePos = PathUtil.validNodePos(entity, node, target, xzSearchRadius, ySearchRadius);
        if (validNodePos != null) {
            return new Node(validNodePos.getX(), validNodePos.getY(), validNodePos.getZ());
        }
        return null;
    }

    public static BlockPos validPos(Entity entity, BlockPos targetPos, int xzRadius, int yRadius) {
        BlockPos entityPos = entity.blockPosition();
        ArrayList<BlockPos> possiblePos = new ArrayList<BlockPos>();
        for (int x = -xzRadius; x <= xzRadius; ++x) {
            for (int z = -xzRadius; z <= xzRadius; ++z) {
                for (int y = -yRadius; y <= yRadius; ++y) {
                    boolean canBelowCollide;
                    BlockPos check = entityPos.offset(x, y, z);
                    boolean canCollide = !entity.level().getBlockState(check).getCollisionShape((BlockGetter)entity.level(), check).isEmpty();
                    boolean bl = canBelowCollide = !entity.level().getBlockState(check.below()).getCollisionShape((BlockGetter)entity.level(), check).isEmpty();
                    if (!canBelowCollide || canCollide) continue;
                    possiblePos.add(check);
                }
            }
        }
        if (possiblePos.isEmpty()) {
            return null;
        }
        HashMap<Double, BlockPos> closestPos = new HashMap<Double, BlockPos>();
        possiblePos.forEach(testPos -> {
            if (targetPos != null) {
                closestPos.put(PathUtil.blockDist(testPos, targetPos), (BlockPos)testPos);
            }
        });
        AtomicLong minDist = new AtomicLong(0L);
        closestPos.forEach((distance, blockPos) -> {
            if (minDist.get() == 0L || distance < (double)minDist.get()) {
                minDist.set(distance.longValue());
            }
        });
        return (BlockPos)closestPos.get(minDist.doubleValue());
    }

    public static BlockPos validNodePos(Entity entity, Node node, BlockPos targetPos, int xzRadius, int yRadius) {
        BlockPos nodePos = node.asBlockPos();
        ArrayList<BlockPos> possiblePos = new ArrayList<BlockPos>();
        for (int x = -xzRadius; x <= xzRadius; ++x) {
            for (int z = -xzRadius; z <= xzRadius; ++z) {
                for (int y = -yRadius; y <= yRadius; ++y) {
                    boolean canBelowCollide;
                    BlockPos check = nodePos.offset(x, y, z);
                    boolean canCollide = !entity.level().getBlockState(check).getCollisionShape((BlockGetter)entity.level(), check).isEmpty();
                    boolean bl = canBelowCollide = !entity.level().getBlockState(check.below()).getCollisionShape((BlockGetter)entity.level(), check).isEmpty();
                    if (!canBelowCollide || canCollide) continue;
                    possiblePos.add(check);
                }
            }
        }
        if (possiblePos.isEmpty()) {
            return null;
        }
        HashMap<Double, BlockPos> closestPos = new HashMap<Double, BlockPos>();
        possiblePos.forEach(testPos -> {
            if (targetPos != null) {
                closestPos.put(PathUtil.blockDist(testPos, targetPos), (BlockPos)testPos);
            }
        });
        AtomicLong minDist = new AtomicLong(0L);
        closestPos.forEach((distance, blockPos) -> {
            if (minDist.get() == 0L || distance < (double)minDist.get()) {
                minDist.set(distance.longValue());
            }
        });
        return (BlockPos)closestPos.get(minDist.doubleValue());
    }

    public static int distToCollider(Entity entity) {
        int depth = 0;
        BlockPos entPos = entity.blockPosition();
        while (entity.level().getBlockState(entPos.below(depth + 1)).isAir() && ++depth <= 63) {
        }
        return depth;
    }

    public static int distToCollider(Entity entity, Vec3i offset) {
        int depth = 0;
        BlockPos entPos = entity.blockPosition();
        while (entity.level().getBlockState(entPos.offset(offset).below(depth + 1)).isAir() && ++depth <= 63) {
        }
        return depth;
    }

    public static Vec3i getEntityVec(Entity entity) {
        return new Vec3i(entity.getDirection().getStepX(), entity.getDirection().getStepY(), entity.getDirection().getStepZ());
    }

    private static double blockDist(BlockPos block1, BlockPos block2) {
        int x1 = block1.getX();
        int y1 = block1.getY();
        int z1 = block1.getZ();
        int x2 = block2.getX();
        int y2 = block2.getY();
        int z2 = block2.getZ();
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
    }

    private static int valDifference(int start, int end) {
        return end - start;
    }
}

