/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.core.timer;

import net.minecraft.world.entity.Entity;
import pt.gif.cave_dweller.common.CaveDweller;
import pt.gif.cave_dweller.core.timer.TickingEvent;
import pt.gif.cave_dweller.core.util.Utils;
import pt.gif.cave_dweller.server.config.ServerConfig;

public class NoiseTickingEvent {
    private final TickingEvent NoiseTick = new TickingEvent();
    public Entity victim;

    public NoiseTickingEvent() {
        this.resetNoise();
    }

    public void tick() {
        this.NoiseTick.tick();
    }

    public boolean hasNoiseExpired() {
        if (Utils.isOnSurface(this.victim)) {
            return this.NoiseTick.getTick() >= (int)((double)this.NoiseTick.getTargetTick() * (Double)ServerConfig.SURFACE_TIMER_MULTIPLIER.get());
        }
        return this.NoiseTick.trigger();
    }

    public void resetNoise() {
        int max;
        int min = (Integer)ServerConfig.RESET_NOISE_MIN.get();
        if (min > (max = ((Integer)ServerConfig.RESET_NOISE_MAX.get()).intValue())) {
            int temp = min;
            min = max;
            max = temp;
        }
        this.NoiseTick.reset(CaveDweller.RANDOM.nextInt(min, max));
    }

    public String toString() {
        String name = this.victim != null ? this.victim.getName().toString() : "NONE";
        return name + " | " + this.NoiseTick.getTick() + "/" + this.NoiseTick.getTargetTick();
    }
}

