/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.core.timer;

import net.minecraft.world.entity.Entity;
import pt.gif.cave_dweller.common.CaveDweller;
import pt.gif.cave_dweller.core.timer.TickingEvent;
import pt.gif.cave_dweller.core.util.Utils;
import pt.gif.cave_dweller.server.config.ServerConfig;

public class SpawnTickingEvent {
    private final TickingEvent SpawnTick = new TickingEvent();
    public Entity victim;

    public SpawnTickingEvent() {
        this.resetSpawn();
    }

    public void tick() {
        this.SpawnTick.tick();
    }

    public boolean hasSpawnExpired() {
        if (Utils.isOnSurface(this.victim)) {
            return this.SpawnTick.getTick() >= (int)((double)this.SpawnTick.getTargetTick() * (Double)ServerConfig.SURFACE_TIMER_MULTIPLIER.get());
        }
        return this.SpawnTick.trigger();
    }

    public void resetSpawn() {
        int max;
        int min = (Integer)ServerConfig.RESET_NOISE_MIN.get();
        if (min > (max = ((Integer)ServerConfig.RESET_NOISE_MAX.get()).intValue())) {
            int temp = min;
            min = max;
            max = temp;
        }
        this.SpawnTick.reset(CaveDweller.RANDOM.nextInt(min, max));
    }

    public String toString() {
        String name = this.victim != null ? this.victim.getName().toString() : "NONE";
        return name + " | " + this.SpawnTick.getTick() + "/" + this.SpawnTick.getTargetTick();
    }
}

