/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.core.timer;

import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import pt.gif.cave_dweller.common.CaveDweller;
import pt.gif.cave_dweller.core.util.Utils;
import pt.gif.cave_dweller.server.config.ServerConfig;

public class Timer {
    @Nullable
    public Entity currentVictim;
    public int currentSpawn;
    public int currentNoise;
    public int targetSpawn;
    public int targetNoise;

    public Timer() {
        this.resetSpawnTimer();
        this.resetNoiseTimer();
    }

    public Timer(@Nullable Entity currentVictim) {
        this.currentVictim = currentVictim;
    }

    public boolean isSpawnTimerReached() {
        if (Utils.isOnSurface(this.currentVictim)) {
            return this.currentSpawn >= (int)((double)this.targetSpawn * (Double)ServerConfig.SURFACE_TIMER_MULTIPLIER.get());
        }
        return this.currentSpawn >= this.targetSpawn;
    }

    public boolean isNoiseTimerReached() {
        if (Utils.isOnSurface(this.currentVictim)) {
            return this.currentNoise >= (int)((double)this.targetNoise * (Double)ServerConfig.SURFACE_TIMER_MULTIPLIER.get());
        }
        return this.currentNoise >= this.targetNoise;
    }

    public void resetNoiseTimer() {
        int min = (Integer)ServerConfig.RESET_NOISE_MIN.get();
        int max = (Integer)ServerConfig.RESET_NOISE_MAX.get();
        if (max < min) {
            int temp = min;
            min = max;
            max = temp;
            CaveDweller.LOGGER.error("Configuration for 'RESET_NOISE' was wrong - max [{}] was smaller than min [{}] - values have been switched to prevent a crash", (Object)max, (Object)min);
        }
        int noiseTimer = CaveDweller.RANDOM.nextInt(Utils.secondsToTicks(min), Utils.secondsToTicks(max + 1));
        this.currentNoise = 0;
        this.targetNoise = noiseTimer;
    }

    public void resetSpawnTimer() {
        int spawnTimer;
        if (CaveDweller.RANDOM.nextDouble() <= (Double)ServerConfig.CAN_SPAWN_COOLDOWN_CHANCE.get()) {
            spawnTimer = Utils.secondsToTicks((Integer)ServerConfig.CAN_SPAWN_COOLDOWN.get());
        } else {
            int min = (Integer)ServerConfig.CAN_SPAWN_MIN.get();
            int max = (Integer)ServerConfig.CAN_SPAWN_MAX.get();
            if (max < min) {
                int temp = min;
                min = max;
                max = temp;
                CaveDweller.LOGGER.error("Configuration for 'RESET_CALM' was wrong - max [{}] was smaller than min [{}] - values have been switched to prevent a crash", (Object)max, (Object)min);
            }
            spawnTimer = CaveDweller.RANDOM.nextInt(Utils.secondsToTicks(min), Utils.secondsToTicks(max + 1));
        }
        this.currentSpawn = 0;
        this.targetSpawn = spawnTimer;
    }

    public String toString() {
        String name = this.currentVictim != null ? this.currentVictim.getName().toString() : "NONE";
        return name + " | " + this.currentSpawn + "/" + this.targetSpawn + " | " + this.currentNoise + "/" + this.targetNoise;
    }
}

