/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.core.util;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.pathfinder.Path;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;
import pt.gif.cave_dweller.common.CaveDweller;
import pt.gif.cave_dweller.server.config.ServerConfig;
import pt.gif.cave_dweller.server.entities.CaveDwellerEntity;

public class Utils {
    public static int ticksToSeconds(int ticks) {
        return ticks / 20;
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static int minutesToTicks(int minutes) {
        return Utils.secondsToTicks(minutes * 60);
    }

    public static String getTextureAppend() {
        return "";
    }

    public static boolean isValidTarget(Entity entity) {
        Player player;
        if (entity == null) {
            return false;
        }
        if (!entity.isAlive()) {
            return false;
        }
        if (!((Boolean)ServerConfig.TARGET_INVISIBLE.get()).booleanValue() && entity.isInvisible()) {
            return false;
        }
        return !(entity instanceof Player) || !(player = (Player)entity).isCreative() && !player.isSpectator();
    }

    public static LivingEntity getValidTarget(@NotNull CaveDwellerEntity caveDweller) {
        return caveDweller.level().getNearestPlayer(caveDweller.position().x, caveDweller.position().y, caveDweller.position().z, 128.0, Utils::isValidTarget);
    }

    public static boolean isOnSurface(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockPos blockPos = entity.blockPosition();
            if (level2.canSeeSky(blockPos)) {
                return true;
            }
            Holder biomeHolder = level2.getBiome(blockPos);
            if (biomeHolder.is(Tags.Biomes.IS_CAVE) || biomeHolder.is(Tags.Biomes.IS_UNDERGROUND)) {
                return false;
            }
            int baseSkyLightLevel = level2.getBrightness(LightLayer.SKY, blockPos) - level2.getSkyDarken();
            return baseSkyLightLevel > 0;
        }
        return false;
    }

    public static <T extends Mob> Optional<T> trySpawnMob(@NotNull Entity currentVictim, EntityType<T> entityType, MobSpawnType spawnType, ServerLevel level, BlockPos blockPosition, int attempts, int xzOffset, int yOffset, SpawnUtil.Strategy strategy) {
        BlockPos.MutableBlockPos mutableBlockPosition = blockPosition.mutable();
        for (int i = 0; i < attempts; ++i) {
            Mob entity;
            int xOffset = Mth.randomBetweenInclusive((RandomSource)level.random, (int)(-xzOffset), (int)xzOffset);
            int zOffset = Mth.randomBetweenInclusive((RandomSource)level.random, (int)(-xzOffset), (int)xzOffset);
            mutableBlockPosition.setWithOffset((Vec3i)blockPosition, xOffset, yOffset, zOffset);
            if (!level.getWorldBorder().isWithinBounds((BlockPos)mutableBlockPosition) || !SpawnPlacements.isSpawnPositionOk(entityType, (LevelReader)level, (BlockPos)mutableBlockPosition) || !((entity = (Mob)entityType.create(level, null, (BlockPos)mutableBlockPosition, spawnType, true, true)) instanceof CaveDwellerEntity)) continue;
            if (entity.checkSpawnRules((LevelAccessor)level, spawnType) && entity.checkSpawnObstruction((LevelReader)level)) {
                boolean isValidSpawn;
                boolean bl = isValidSpawn = entity.level().getNearestPlayer((Entity)entity, (double)((Integer)ServerConfig.SPAWN_DISTANCE.get()).intValue()) == null;
                if (isValidSpawn && ((Boolean)ServerConfig.CHECK_PATH_TO_SPAWN.get()).booleanValue()) {
                    Path path = entity.getNavigation().createPath(currentVictim, 0);
                    boolean bl2 = isValidSpawn = path != null && path.canReach();
                }
                if (isValidSpawn) {
                    entity.getNavigation().createPath(entity.blockPosition(), 0);
                    entity.getNavigation().stop();
                    level.addFreshEntityWithPassengers((Entity)entity);
                    return Optional.of(entity);
                }
            }
            entity.discard();
        }
        CaveDweller.LOGGER.debug("Cave Dweller could not pass the spawn checks, target: [{}]", (Object)currentVictim);
        return Optional.empty();
    }

    public static void debugUtil(String name, ServerTickEvent event) {
        MutableComponent debug = Component.literal((String)("Event '" + name + "' has completed! Resetting..."));
        MinecraftServer server = event.getServer();
        if (server != null) {
            server.getPlayerList().broadcastSystemMessage((Component)debug, false);
        }
    }
}

