/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.server.config;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ModConfigSpec;
import pt.gif.cave_dweller.common.datagen.ModBiomeTagsProvider;

public class ServerConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static ModConfigSpec.IntValue CAN_SPAWN_MIN;
    public static ModConfigSpec.IntValue CAN_SPAWN_MAX;
    public static ModConfigSpec.IntValue CAN_SPAWN_COOLDOWN;
    public static ModConfigSpec.DoubleValue CAN_SPAWN_COOLDOWN_CHANCE;
    public static ModConfigSpec.IntValue RESET_NOISE_MIN;
    public static ModConfigSpec.IntValue RESET_NOISE_MAX;
    public static ModConfigSpec.IntValue TIME_UNTIL_LEAVE;
    public static ModConfigSpec.IntValue TIME_UNTIL_LEAVE_CHASE;
    public static ModConfigSpec.DoubleValue SURFACE_TIMER_MULTIPLIER;
    public static ModConfigSpec.DoubleValue SPAWN_CHANCE_PER_TICK;
    public static ModConfigSpec.ConfigValue<Integer> SPAWN_HEIGHT;
    public static ModConfigSpec.BooleanValue ALLOW_SURFACE_SPAWN;
    public static ModConfigSpec.IntValue SKY_LIGHT_LEVEL;
    public static ModConfigSpec.IntValue BLOCK_LIGHT_LEVEL;
    public static ModConfigSpec.IntValue MAXIMUM_AMOUNT;
    public static ModConfigSpec.IntValue SPAWN_DISTANCE;
    public static ModConfigSpec.BooleanValue CHECK_PATH_TO_SPAWN;
    public static ModConfigSpec.ConfigValue<List<? extends String>> DIMENSION_WHITELIST;
    public static ModConfigSpec.BooleanValue OVERRIDE_BIOME_DATAPACK_CONFIG;
    public static ModConfigSpec.BooleanValue SURFACE_BIOMES_IS_WHITELIST;
    public static ModConfigSpec.ConfigValue<List<? extends String>> SURFACE_BIOMES;
    public static ModConfigSpec.IntValue SPOTTING_RANGE;
    public static ModConfigSpec.BooleanValue CAN_DISABLE_SHIELDS;
    public static ModConfigSpec.BooleanValue CAN_CLIMB;
    public static ModConfigSpec.BooleanValue CAN_BREAK_DOOR;
    public static ModConfigSpec.IntValue BREAK_DOOR_TIME;
    public static ModConfigSpec.BooleanValue ALLOW_RIDING;
    public static ModConfigSpec.BooleanValue TARGET_INVISIBLE;
    public static ModConfigSpec.DoubleValue MAX_HEALTH;
    public static ModConfigSpec.DoubleValue ATTACK_DAMAGE;
    public static ModConfigSpec.DoubleValue ATTACK_SPEED;
    public static ModConfigSpec.DoubleValue MOVEMENT_SPEED;
    public static ModConfigSpec.DoubleValue DEPTH_STRIDER_BONUS;
    public static ModConfigSpec.BooleanValue ONLY_PLAY_NOISE_TO_TARGET;

    private static boolean resourcePredicate(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            String string = (String)object;
            return string.split(":").length == 2;
        }
        if (object instanceof List) {
            List list = (List)object;
            for (Object listElement : list) {
                if (listElement instanceof String) {
                    String string = (String)listElement;
                    if (string.split(":").length == 2) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidDimension(String key) {
        return ((List)DIMENSION_WHITELIST.get()).contains(key);
    }

    public static boolean isInValidBiome(Entity entity) {
        if (entity == null) {
            return false;
        }
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Holder biome = serverLevel.getBiome(entity.blockPosition());
            boolean isWhitelist = (Boolean)SURFACE_BIOMES_IS_WHITELIST.get();
            boolean isBiomeInList = false;
            if (((Boolean)OVERRIDE_BIOME_DATAPACK_CONFIG.get()).booleanValue()) {
                Optional unwrapped = biome.unwrapKey();
                if (unwrapped.isPresent()) {
                    isBiomeInList = ((List)SURFACE_BIOMES.get()).contains(((ResourceKey)unwrapped.get()).location().toString());
                }
            } else {
                isBiomeInList = biome.is(ModBiomeTagsProvider.CAVE_DWELLER_SURFACE_BIOMES);
            }
            return isWhitelist && isBiomeInList || !isWhitelist && !isBiomeInList;
        }
        return false;
    }

    static {
        BUILDER.push("Timers");
        BUILDER.push("Spawn");
        CAN_SPAWN_MIN = BUILDER.comment("Minimum time between spawns in seconds").defineInRange("can_spawn_min", 300, 0, 86400);
        CAN_SPAWN_MAX = BUILDER.comment("Maximum time between spawns in seconds").defineInRange("can_spawn_max", 600, 0, 86400);
        CAN_SPAWN_COOLDOWN_CHANCE = BUILDER.comment("Chance for a spawn cooldown to occur").defineInRange("can_spawn_cooldown_chance", 0.4, 0.0, 1.0);
        CAN_SPAWN_COOLDOWN = BUILDER.comment("Spawn cooldown length in seconds").defineInRange("can_spawn_cooldown", 1200, 0, 86400);
        BUILDER.pop();
        BUILDER.push("Noise");
        RESET_NOISE_MIN = BUILDER.comment("Minimum time between noise occurrences in seconds").defineInRange("reset_noise_min", 240, 0, 86400);
        RESET_NOISE_MAX = BUILDER.comment("Maximum time between noise occurrences in seconds").defineInRange("reset_noise_max", 360, 0, 86400);
        BUILDER.pop();
        BUILDER.push("Leave");
        TIME_UNTIL_LEAVE = BUILDER.comment("Time (in seconds) it takes for the Cave Dweller to leave").defineInRange("time_until_leave", 300, 1, 6000);
        TIME_UNTIL_LEAVE_CHASE = BUILDER.comment("Time (in seconds) it takes for the Cave Dweller to leave once a chase begins").defineInRange("time_until_leave_chase", 30, 1, 600);
        BUILDER.pop();
        SURFACE_TIMER_MULTIPLIER = BUILDER.comment("Modify the timers for the surface (to reduce or increase them), based on the general timer set (e.g. spawn timer of 300 seconds -> 0.3 turns it into 90 seconds and 1.7 turns it into 510 seconds for the surface)").defineInRange("surface_timer_multiplier", 1.0, 0.0, 5.0);
        BUILDER.pop();
        BUILDER.push("Spawn Conditions");
        SPAWN_CHANCE_PER_TICK = BUILDER.comment("The spawn chance per tick (once the spawn timer is finished)").defineInRange("spawn_chance_per_tick", 0.005, 0.0, 1.0);
        SPAWN_HEIGHT = BUILDER.comment("Depth at which the Cave Dweller can start to spawn").define("spawn_height", (Object)40);
        ALLOW_SURFACE_SPAWN = BUILDER.comment("Whether the Cave Dweller can spawn on the surface or not").define("allow_surface_spawn", false);
        SKY_LIGHT_LEVEL = BUILDER.comment("The maximum sky light level the Cave Dweller can spawn at").defineInRange("sky_light_level", 8, 0, 15);
        BLOCK_LIGHT_LEVEL = BUILDER.comment("The maximum block light level the Cave Dweller can spawn at").defineInRange("block_light_level", 15, 0, 15);
        MAXIMUM_AMOUNT = BUILDER.comment("The maximum amount of cave dwellers which can exist at the same time").defineInRange("maximum_amount", 3, 0, 100);
        SPAWN_DISTANCE = BUILDER.comment("How close to players the cave dweller is allowed to spawn (in blocks)").defineInRange("spawn_distance", 16, 0, 64);
        CHECK_PATH_TO_SPAWN = BUILDER.comment("If set to true the cave dweller will try to find a spawn position with a possible path to the player").define("check_path_to_spawn", true);
        BUILDER.push("Dimensions");
        DIMENSION_WHITELIST = BUILDER.comment("The dimensions where the Cave Dweller can spawn in (Whitelist)").defineList("dimension_whitelist", List.of("minecraft:overworld"), ServerConfig::resourcePredicate);
        BUILDER.pop();
        BUILDER.push("Biomes");
        OVERRIDE_BIOME_DATAPACK_CONFIG = BUILDER.comment("If you don't want to create a datapack to configure the biomes").define("override_biome_datapack_config", false);
        SURFACE_BIOMES_IS_WHITELIST = BUILDER.comment("Use the surface biome list either as white- or blacklist").define("surface_biomes_is_whitelist", true);
        SURFACE_BIOMES = BUILDER.comment("Either white- or blacklist of the surface biomes the Cave Dweller can spawn in (Syntax: modid:biome, e.g. `minecraft:plains`)").defineList("surface_biomes", List.of(), ServerConfig::resourcePredicate);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Behaviour");
        SPOTTING_RANGE = BUILDER.comment("The distance in blocks at which the Cave Dweller can detect whether a player is looking at it or not").defineInRange("spotting_range", 60, 0, 128);
        CAN_DISABLE_SHIELDS = BUILDER.comment("Whether it can disable shields or not").define("can_disable_shields", true);
        CAN_CLIMB = BUILDER.comment("Whether the cave dweller can climb or not").define("can_climb", true);
        CAN_BREAK_DOOR = BUILDER.comment("Whether the cave dweller can break down doors or not").define("can_break_door", true);
        BREAK_DOOR_TIME = BUILDER.comment("Time (in seconds) it takes the Cave Dweller to break down a door").defineInRange("break_door_time", 3, 1, 60);
        ALLOW_RIDING = BUILDER.comment("Allow the Cave Dweller to follow vanilla riding logic (e.g. boats)").define("allow_riding", false);
        TARGET_INVISIBLE = BUILDER.comment("Whether invisible players can be targets or not").define("target_invisible", true);
        BUILDER.pop();
        BUILDER.push("Attributes");
        MAX_HEALTH = BUILDER.comment("Maximum health").defineInRange("maximum_health", 450.0, 1.0, 100000.0);
        ATTACK_DAMAGE = BUILDER.comment("Attack damage").defineInRange("attack_damage", 7.0, 0.0, 1000.0);
        ATTACK_SPEED = BUILDER.comment("Attack speed").defineInRange("attack_speed", 0.35, 0.0, 10.0);
        MOVEMENT_SPEED = BUILDER.comment("Movement speed").defineInRange("movement_speed", 0.5, 0.0, 5.0);
        DEPTH_STRIDER_BONUS = BUILDER.comment("Depth Strider (movement speed in water) bonus").defineInRange("depth_strider_bonus", 1.5, 0.0, 3.0);
        BUILDER.pop();
        BUILDER.push("Misc");
        ONLY_PLAY_NOISE_TO_TARGET = BUILDER.comment("Only play the ambient noises to the current (spawn) target (Note: The target can change when a spawn attempt is not successful)").define("only_play_noise_to_target", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

