/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.server.entities;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import pt.gif.cave_dweller.common.network.CaveSound;
import pt.gif.cave_dweller.common.registry.ModSounds;
import pt.gif.cave_dweller.core.util.Utils;
import pt.gif.cave_dweller.server.config.ServerConfig;
import pt.gif.cave_dweller.server.goals.CaveDwellerBreakDoorGoal;
import pt.gif.cave_dweller.server.goals.CaveDwellerChaseGoal;
import pt.gif.cave_dweller.server.goals.CaveDwellerFleeGoal;
import pt.gif.cave_dweller.server.goals.CaveDwellerStareGoal;
import pt.gif.cave_dweller.server.goals.CaveDwellerStrollGoal;
import pt.gif.cave_dweller.server.goals.CaveDwellerTargetSeesMeGoal;
import pt.gif.cave_dweller.server.goals.CaveDwellerTargetTooCloseGoal;
import pt.gif.cave_dweller.server.goals.CustomHurtByTargetGoal;
import pt.gif.cave_dweller.server.goals.Roll;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CaveDwellerEntity
extends Monster
implements GeoEntity {
    private final RawAnimation CHASE = RawAnimation.begin().thenLoop("animation.cave_dweller.new_run");
    private final RawAnimation CHASE_IDLE = RawAnimation.begin().thenLoop("animation.cave_dweller.run_idle");
    private final RawAnimation CROUCH_RUN = RawAnimation.begin().thenLoop("animation.cave_dweller.crouch_run_new");
    private final RawAnimation CROUCH_IDLE = RawAnimation.begin().thenLoop("animation.cave_dweller.crouch_idle");
    private final RawAnimation CALM_RUN = RawAnimation.begin().thenLoop("animation.cave_dweller.calm_move");
    private final RawAnimation CALM_STILL = RawAnimation.begin().thenLoop("animation.cave_dweller.calm_idle");
    private final RawAnimation IS_SPOTTED = RawAnimation.begin().thenPlayAndHold("animation.cave_dweller.spotted");
    private final RawAnimation CRAWL_MOVE = RawAnimation.begin().thenLoop("animation.cave_dweller.crawl_move");
    private final RawAnimation CRAWL_IDLE = RawAnimation.begin().thenLoop("animation.cave_dweller.crawl_idle");
    private final RawAnimation FLEE = RawAnimation.begin().thenLoop("animation.cave_dweller.flee");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Boolean> FLEEING_ACCESSOR = SynchedEntityData.defineId(CaveDwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> CROUCHING_ACCESSOR = SynchedEntityData.defineId(CaveDwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> CRAWLING_ACCESSOR = SynchedEntityData.defineId(CaveDwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> SPOTTED_ACCESSOR = SynchedEntityData.defineId(CaveDwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> CLIMBING_ACCESSOR = SynchedEntityData.defineId(CaveDwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public Roll currentRoll = Roll.STROLL;
    public boolean isFleeing;
    public boolean hasSpawned;
    public boolean pleaseStopMoving;
    public boolean targetIsFacingMe;
    private int ticksTillRemove;
    private int chaseSoundClock;
    private boolean alreadyPlayedFleeSound;
    private boolean alreadyPlayedSpottedSound;
    private boolean startedPlayingChaseSound;
    private boolean alreadyPlayedDeathSound;

    public CaveDwellerEntity(EntityType<? extends CaveDwellerEntity> entityType, Level level) {
        super(entityType, level);
        this.refreshDimensions();
        this.ticksTillRemove = Utils.secondsToTicks((Integer)ServerConfig.TIME_UNTIL_LEAVE.get());
        this.setPathfindingMalus(PathType.UNPASSABLE_RAIL, 0.0f);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.setAttribute(this.getAttribute(Attributes.MAX_HEALTH), (Double)ServerConfig.MAX_HEALTH.get());
        this.setAttribute(this.getAttribute(Attributes.ATTACK_DAMAGE), (Double)ServerConfig.ATTACK_DAMAGE.get());
        this.setAttribute(this.getAttribute(Attributes.ATTACK_SPEED), (Double)ServerConfig.ATTACK_SPEED.get());
        this.setAttribute(this.getAttribute(Attributes.MOVEMENT_SPEED), (Double)ServerConfig.MOVEMENT_SPEED.get());
        this.setAttribute(this.getAttribute(Attributes.STEP_HEIGHT), 1.6f);
    }

    private void setAttribute(AttributeInstance attribute, double newValue) {
        if (attribute != null) {
            double baseValue = attribute.getBaseValue();
            float difference = (float)(newValue - baseValue);
            attribute.setBaseValue(newValue);
            if (attribute.getAttribute() == Attributes.MAX_HEALTH) {
                this.setHealth(this.getHealth() + difference);
            } else if (attribute.getAttribute() == Attributes.MOVEMENT_SPEED) {
                this.setSpeed(this.getSpeed() + difference);
            }
        }
    }

    public static AttributeSupplier getAttributeBuilder() {
        double maxHealth = 450.0;
        double attackDamage = 7.0;
        double attackSpeed = 0.35;
        double movementSpeed = 0.3;
        double followRange = 100.0;
        double knockbackResist = 0.8;
        return CaveDwellerEntity.createMobAttributes().add(Attributes.MAX_HEALTH, maxHealth).add(Attributes.ATTACK_DAMAGE, attackDamage).add(Attributes.ATTACK_SPEED, attackSpeed).add(Attributes.MOVEMENT_SPEED, movementSpeed).add(Attributes.FOLLOW_RANGE, followRange).add(Attributes.KNOCKBACK_RESISTANCE, knockbackResist).build();
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLEEING_ACCESSOR, (Object)false);
        builder.define(CROUCHING_ACCESSOR, (Object)false);
        builder.define(CRAWLING_ACCESSOR, (Object)false);
        builder.define(SPOTTED_ACCESSOR, (Object)false);
        builder.define(CLIMBING_ACCESSOR, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new CaveDwellerChaseGoal(this, true));
        this.goalSelector.addGoal(1, (Goal)new CaveDwellerFleeGoal(this, 20.0f, 1.0));
        this.goalSelector.addGoal(2, (Goal)new CaveDwellerStareGoal(this));
        if (((Boolean)ServerConfig.CAN_BREAK_DOOR.get()).booleanValue()) {
            this.goalSelector.addGoal(2, (Goal)new CaveDwellerBreakDoorGoal((Mob)this, difficulty -> true));
        }
        this.goalSelector.addGoal(3, (Goal)new CaveDwellerStrollGoal((PathfinderMob)this, 0.35));
        this.targetSelector.addGoal(0, (Goal)new CustomHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new CaveDwellerTargetTooCloseGoal(this, 12.0f));
        this.targetSelector.addGoal(2, (Goal)new CaveDwellerTargetSeesMeGoal(this));
    }

    public void disappear() {
        this.playDisappearSound();
        this.discard();
    }

    public boolean hasSpawned() {
        return this.hasSpawned;
    }

    protected boolean canRide(@NotNull Entity vehicle) {
        if (((Boolean)ServerConfig.ALLOW_RIDING.get()).booleanValue()) {
            return super.canRide(vehicle);
        }
        return false;
    }

    public boolean startRiding(@NotNull Entity vehicle, boolean force) {
        if (((Boolean)ServerConfig.ALLOW_RIDING.get()).booleanValue()) {
            return super.startRiding(vehicle, force);
        }
        return false;
    }

    public boolean canDisableShield() {
        return (Boolean)ServerConfig.CAN_DISABLE_SHIELDS.get();
    }

    public void tick() {
        --this.ticksTillRemove;
        if (this.ticksTillRemove <= 0) {
            this.disappear();
        }
        if (this.goalSelector.getAvailableGoals().isEmpty() || this.targetSelector.getAvailableGoals().isEmpty()) {
            this.registerGoals();
            this.goalSelector.tick();
            this.targetSelector.tick();
        }
        if (this.getTarget() != null) {
            this.targetIsFacingMe = this.isLookingAtMe((Entity)this.getTarget(), false);
        }
        if (this.level() instanceof ServerLevel) {
            boolean shouldCrawl;
            boolean isAboveSolid = this.level().getBlockState(this.blockPosition().above()).isSolid();
            boolean isTwoAboveSolid = this.level().getBlockState(this.blockPosition().above(2)).isSolid();
            boolean isThreeAboveSolid = this.level().getBlockState(this.blockPosition().above(3)).isSolid();
            Vec3i offset = this.getDirectionVector();
            boolean isFacingSolid = this.level().getBlockState(this.blockPosition().relative(this.getDirection())).isSolid();
            boolean isOffsetFacingSolid = this.level().getBlockState(this.blockPosition().offset(offset)).isSolid();
            boolean isOffsetFacingAboveSolid = this.level().getBlockState(this.blockPosition().offset(offset).above()).isSolid();
            boolean isOffsetFacingTwoAboveSolid = this.level().getBlockState(this.blockPosition().offset(offset).above(2)).isSolid();
            Vec3i i_offset = offset.multiply(-1);
            boolean isBehindSolid = this.level().getBlockState(this.blockPosition().offset(i_offset)).isSolid();
            boolean isBehindAboveSolid = this.level().getBlockState(this.blockPosition().offset(i_offset).above()).isSolid();
            boolean isBehindTwoAboveSolid = this.level().getBlockState(this.blockPosition().offset(i_offset).above(2)).isSolid();
            boolean shouldCrouch = isTwoAboveSolid || isBehindTwoAboveSolid && !isBehindAboveSolid && !isBehindSolid || !isOffsetFacingSolid && !isOffsetFacingAboveSolid && isOffsetFacingTwoAboveSolid || isThreeAboveSolid && isOffsetFacingSolid && !isOffsetFacingAboveSolid && !isOffsetFacingTwoAboveSolid;
            boolean bl = shouldCrawl = isAboveSolid || isBehindAboveSolid && !isBehindSolid || !isOffsetFacingSolid && isOffsetFacingAboveSolid || isOffsetFacingSolid && !isOffsetFacingAboveSolid && (isOffsetFacingTwoAboveSolid || isTwoAboveSolid && !isOffsetFacingTwoAboveSolid);
            if (this.isAggressive() || this.isFleeing) {
                this.entityData.set(SPOTTED_ACCESSOR, (Object)false);
            }
            this.setClimbing(this.horizontalCollision);
            this.entityData.set(CROUCHING_ACCESSOR, (Object)shouldCrouch);
            this.setCrawling(shouldCrawl);
        }
        if (((Boolean)this.entityData.get(SPOTTED_ACCESSOR)).booleanValue()) {
            this.playSpottedSound();
        }
        this.refreshDimensions();
        this.getNavigation().setSpeedModifier(this.getSpeedModifier());
        super.tick();
    }

    public double getSpeedModifier() {
        return this.isCrawling() ? 0.35 : (this.isCrouching() ? 0.6 : 0.85);
    }

    @NotNull
    public final EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        if (((Boolean)this.entityData.get(CRAWLING_ACCESSOR)).booleanValue()) {
            return EntityDimensions.fixed((float)0.5f, (float)0.5f);
        }
        if (((Boolean)this.entityData.get(CROUCHING_ACCESSOR)).booleanValue()) {
            return EntityDimensions.fixed((float)0.5f, (float)1.7f);
        }
        return super.getDefaultDimensions(pose);
    }

    private boolean isMoving() {
        Vec3 velocity = this.getDeltaMovement();
        float avgVelocity = (float)(Math.abs(velocity.x) + Math.abs(velocity.z)) / 2.0f;
        return avgVelocity > 0.03f;
    }

    public void reRoll() {
        this.currentRoll = Roll.fromValue(new Random().nextInt(3));
    }

    public void pickRoll(@NotNull List<Roll> rolls) {
        this.currentRoll = rolls.get(new Random().nextInt(rolls.size()));
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        if (!((Boolean)ServerConfig.CAN_CLIMB.get()).booleanValue()) {
            return false;
        }
        if (this.getTarget() != null) {
            return !this.isCrawling() && !this.isCrouching() && (Boolean)this.entityData.get(CLIMBING_ACCESSOR) != false;
        }
        return false;
    }

    public void setSpotted(boolean value) {
        this.entityData.set(SPOTTED_ACCESSOR, (Object)value);
    }

    public void setClimbing(boolean isClimbing) {
        this.entityData.set(CLIMBING_ACCESSOR, (Object)isClimbing);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        WallClimberNavigation navigation = new WallClimberNavigation((Mob)this, level);
        navigation.setMaxVisitedNodesMultiplier(4.0f);
        return navigation;
    }

    protected PlayState predicate(AnimationState<CaveDwellerEntity> event) {
        boolean isCurrentAboveSolid = this.level().getBlockState(this.blockPosition().above()).isSolid();
        boolean unsure = this.isCrawling() && this.level().getBlockState(this.blockPosition()).isSolid();
        boolean isCurrentTwoAboveSolid = this.level().getBlockState(this.blockPosition().above(2)).isSolid();
        if (isCurrentAboveSolid || unsure) {
            if (event.isMoving()) {
                return event.setAndContinue(this.CRAWL_MOVE);
            }
            return event.setAndContinue(this.CRAWL_IDLE);
        }
        if (isCurrentTwoAboveSolid) {
            if (event.isMoving()) {
                return event.setAndContinue(this.CROUCH_RUN);
            }
            return event.setAndContinue(this.CROUCH_IDLE);
        }
        if (this.isAggressive()) {
            if (event.isMoving()) {
                return event.setAndContinue(this.CHASE);
            }
            return event.setAndContinue(this.CHASE_IDLE);
        }
        if (((Boolean)this.entityData.get(FLEEING_ACCESSOR)).booleanValue()) {
            if (event.isMoving()) {
                return event.setAndContinue(this.FLEE);
            }
            return event.setAndContinue(this.CHASE_IDLE);
        }
        if (this.pleaseStopMoving || ((Boolean)this.entityData.get(SPOTTED_ACCESSOR)).booleanValue() && !event.isMoving()) {
            return event.setAndContinue(this.IS_SPOTTED);
        }
        if (event.isMoving()) {
            return event.setAndContinue(this.CALM_RUN);
        }
        return event.setAndContinue(this.CALM_STILL);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "cave_dweller", 5, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState state) {
        super.playStepSound(pos, state);
        this.playEntitySound(this.chooseStep());
    }

    private void playEntitySound(SoundEvent soundEvent) {
        this.playEntitySound(soundEvent, 1.0f);
    }

    private void playEntitySound(SoundEvent soundEvent, float volume) {
        this.level().playSound(null, (Entity)this, soundEvent, SoundSource.HOSTILE, volume, 1.0f);
    }

    private void playBlockPosSound(ResourceLocation sound, float volume) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            int radius = 32;
            level2.getPlayers(player -> player.distanceToSqr((Entity)this) <= (double)(radius * radius)).forEach(player -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new CaveSound(sound, this.blockPosition(), volume, 1.0f), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    public void playChaseSound() {
        if (this.startedPlayingChaseSound || this.isMoving()) {
            if (this.chaseSoundClock <= 0) {
                Random rand = new Random();
                switch (rand.nextInt(4)) {
                    case 0: {
                        this.playEntitySound(ModSounds.CHASE_1.get(), 3.0f);
                        break;
                    }
                    case 1: {
                        this.playEntitySound(ModSounds.CHASE_2.get(), 3.0f);
                        break;
                    }
                    case 2: {
                        this.playEntitySound(ModSounds.CHASE_3.get(), 3.0f);
                        break;
                    }
                    case 3: {
                        this.playEntitySound(ModSounds.CHASE_4.get(), 3.0f);
                    }
                }
                this.startedPlayingChaseSound = true;
                this.resetChaseSoundClock();
            }
            --this.chaseSoundClock;
        }
    }

    public void playDisappearSound() {
        this.playBlockPosSound(ModSounds.DISAPPEAR.get().getLocation(), 3.0f);
    }

    public void playFleeSound() {
        if (!this.alreadyPlayedFleeSound) {
            Random rand = new Random();
            switch (rand.nextInt(2)) {
                case 0: {
                    this.playEntitySound(ModSounds.FLEE_1.get(), 3.0f);
                    break;
                }
                case 1: {
                    this.playEntitySound(ModSounds.FLEE_2.get(), 3.0f);
                }
            }
            this.alreadyPlayedFleeSound = true;
        }
    }

    public void playSpottedSound() {
        if (!this.alreadyPlayedSpottedSound) {
            this.playEntitySound(ModSounds.SPOTTED.get(), 3.0f);
            this.alreadyPlayedSpottedSound = true;
        }
    }

    private void resetChaseSoundClock() {
        this.chaseSoundClock = Utils.secondsToTicks(5);
    }

    private SoundEvent chooseStep() {
        Random rand = new Random();
        return switch (rand.nextInt(4)) {
            case 1 -> ModSounds.CHASE_STEP_2.get();
            case 2 -> ModSounds.CHASE_STEP_3.get();
            case 3 -> ModSounds.CHASE_STEP_4.get();
            default -> ModSounds.CHASE_STEP_1.get();
        };
    }

    private SoundEvent chooseHurtSound() {
        Random rand = new Random();
        return switch (rand.nextInt(4)) {
            case 1 -> ModSounds.DWELLER_HURT_2.get();
            case 2 -> ModSounds.DWELLER_HURT_3.get();
            case 3 -> ModSounds.DWELLER_HURT_4.get();
            default -> ModSounds.DWELLER_HURT_1.get();
        };
    }

    protected void playHurtSound(@NotNull DamageSource source) {
        SoundEvent soundEvent = this.chooseHurtSound();
        this.playEntitySound(soundEvent, 2.0f);
    }

    public void setCrawling(boolean shouldCrawl) {
        if (shouldCrawl) {
            this.getEntityData().set(CROUCHING_ACCESSOR, (Object)false);
        }
        this.getEntityData().set(CRAWLING_ACCESSOR, (Object)shouldCrawl);
        this.refreshDimensions();
    }

    public boolean isCrawling() {
        return (Boolean)this.entityData.get(CRAWLING_ACCESSOR);
    }

    protected void tickDeath() {
        super.tickDeath();
        if (!this.alreadyPlayedDeathSound) {
            this.playBlockPosSound(ModSounds.DWELLER_DEATH.get().getLocation(), 2.0f);
            this.alreadyPlayedDeathSound = true;
        }
    }

    public boolean isLookingAtMe(Entity target, boolean directlyLooking) {
        if (!Utils.isValidTarget(target)) {
            return false;
        }
        if (target.getEyePosition(1.0f).distanceTo(this.getPosition(1.0f)) > (double)((Integer)ServerConfig.SPOTTING_RANGE.get()).intValue()) {
            return false;
        }
        Vec3 viewVector = target.getViewVector(1.0f).normalize();
        Vec3 difference = new Vec3(this.getX() - target.getX(), this.getEyeY() - target.getEyeY(), this.getZ() - target.getZ());
        difference = difference.normalize();
        double dot = viewVector.dot(difference);
        if (directlyLooking && target instanceof Player) {
            Player player = (Player)target;
            return dot > 0.99 && player.hasLineOfSight((Entity)this);
        }
        return dot > 0.3;
    }

    public boolean teleportToTarget() {
        LivingEntity target = this.getTarget();
        if (target == null) {
            return false;
        }
        Vec3 targetPosition = new Vec3(this.getX() - target.getX(), this.getY(0.5) - target.getEyeY(), this.getZ() - target.getZ());
        targetPosition = targetPosition.normalize();
        double radius = 16.0;
        double d1 = this.getX() + (this.getRandom().nextDouble() - 0.5) * (radius / 2.0) - targetPosition.x * radius;
        double d2 = this.getY() + ((double)this.getRandom().nextInt((int)radius) - radius / 2.0) - targetPosition.y * radius;
        double d3 = this.getZ() + (this.getRandom().nextDouble() - 0.5) * (radius / 2.0) - targetPosition.z * radius;
        BlockPos.MutableBlockPos validPosition = new BlockPos.MutableBlockPos(d1, d2, d3);
        while (validPosition.getY() > this.level().getMinBuildHeight() && !this.level().getBlockState((BlockPos)validPosition).canOcclude()) {
            validPosition.move(Direction.DOWN);
        }
        this.teleportTo(validPosition.getX(), validPosition.getY(), validPosition.getZ());
        return true;
    }

    private Vec3i getDirectionVector() {
        return new Vec3i(this.getDirection().getStepX(), this.getDirection().getStepY(), this.getDirection().getStepZ());
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return this.chooseHurtSound();
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return ModSounds.DWELLER_DEATH.get();
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public boolean isInWall() {
        return false;
    }
}

