/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.server.goals;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import pt.gif.cave_dweller.core.path.PathUtil;
import pt.gif.cave_dweller.core.util.Utils;
import pt.gif.cave_dweller.server.config.ServerConfig;
import pt.gif.cave_dweller.server.entities.CaveDwellerEntity;
import pt.gif.cave_dweller.server.goals.Roll;

public class CaveDwellerChaseGoal
extends Goal {
    private final CaveDwellerEntity caveDweller;
    private final int maxSpeedReached;
    private final boolean followTargetEvenIfNotSeen;
    private LivingEntity previousTarget;
    private long lastGameTimeCheck;
    private int ticksUntilLeave;
    private int ticksUntilNextAttack;
    private int speedUp;

    public CaveDwellerChaseGoal(CaveDwellerEntity caveDweller, boolean followTargetEvenIfNotSeen) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.caveDweller = caveDweller;
        this.followTargetEvenIfNotSeen = followTargetEvenIfNotSeen;
        this.ticksUntilLeave = Utils.secondsToTicks((Integer)ServerConfig.TIME_UNTIL_LEAVE_CHASE.get());
        this.maxSpeedReached = Utils.secondsToTicks(3);
    }

    public boolean canUse() {
        boolean canAttack;
        if (this.caveDweller.isInvisible()) {
            return false;
        }
        if (this.caveDweller.currentRoll != Roll.CHASE) {
            return false;
        }
        if (!this.caveDweller.targetIsFacingMe && !this.caveDweller.getNavigation().isDone()) {
            return false;
        }
        long ticks = this.caveDweller.level().getGameTime();
        if (ticks - this.lastGameTimeCheck < 20L) {
            return false;
        }
        this.lastGameTimeCheck = ticks;
        LivingEntity target = this.caveDweller.getTarget();
        if (!Utils.isValidTarget((Entity)target)) {
            return false;
        }
        if (PathUtil.distToCollider((Entity)target) > 3) {
            return false;
        }
        Path path = this.caveDweller.getNavigation().createPath((Entity)target, 0);
        if (path != null) {
            return true;
        }
        boolean bl = canAttack = this.getAttackReachSqr(target) >= this.caveDweller.distanceToSqr((Entity)target);
        if (canAttack) {
            return true;
        }
        path = this.caveDweller.getNavigation().createPath((Entity)target, 0);
        return path != null;
    }

    public boolean canContinueToUse() {
        LivingEntity target = this.caveDweller.getTarget();
        if (!Utils.isValidTarget((Entity)target)) {
            if (target == null && this.previousTarget instanceof Player) {
                this.caveDweller.disappear();
            }
            return false;
        }
        this.previousTarget = target;
        Path path = this.caveDweller.getNavigation().getPath();
        if (PathUtil.distToCollider((Entity)this.caveDweller.getTarget()) > 3) {
            if (path != null) {
                this.caveDweller.getNavigation().moveTo(PathUtil.pathComposite((Entity)this.caveDweller, path), this.caveDweller.getSpeedModifier());
            }
            return false;
        }
        if (!this.followTargetEvenIfNotSeen) {
            return !this.caveDweller.getNavigation().isDone();
        }
        return this.caveDweller.isWithinRestriction(target.blockPosition());
    }

    public void start() {
        this.caveDweller.setAggressive(true);
        this.ticksUntilNextAttack = 0;
    }

    public void stop() {
        LivingEntity target = this.caveDweller.getTarget();
        if (!Utils.isValidTarget((Entity)target)) {
            this.caveDweller.setTarget(null);
        }
        this.speedUp = 0;
        this.previousTarget = null;
        this.caveDweller.setAggressive(false);
        this.caveDweller.getEntityData().set(CaveDwellerEntity.CRAWLING_ACCESSOR, (Object)false);
        this.caveDweller.getNavigation().stop();
        this.caveDweller.refreshDimensions();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        boolean targetMoved;
        LivingEntity target;
        if (this.ticksUntilLeave <= 0 && !this.caveDweller.targetIsFacingMe) {
            this.caveDweller.disappear();
        }
        if (!Utils.isValidTarget((Entity)(target = this.caveDweller.getTarget()))) {
            return;
        }
        if (PathUtil.distToCollider((Entity)this.caveDweller.getTarget()) > 3) {
            return;
        }
        Path path = this.caveDweller.getNavigation().getPath();
        this.fixPath(path);
        boolean bl = targetMoved = path != null && path.getEndNode() != null && path.getEndNode().distanceTo(target.blockPosition()) > 2.0f;
        if (path == null || this.caveDweller.getNavigation().isStuck() || targetMoved || path.isDone() && !this.shouldClimb(path) || this.caveDweller.getNavigation().shouldRecomputePath(target.blockPosition()) && this.caveDweller.tickCount % 20 == 0) {
            path = this.caveDweller.getNavigation().createPath((Entity)target, 0);
            this.fixPath(path);
        }
        if (path != null && !path.isDone()) {
            if (this.caveDweller.hasLineOfSight((Entity)target)) {
                this.caveDweller.playChaseSound();
            }
            path = PathUtil.pathComposite((Entity)this.caveDweller, path);
        }
        this.caveDweller.getNavigation().moveTo(path, this.caveDweller.getSpeedModifier());
        if (!this.caveDweller.isCrawling()) {
            if (this.caveDweller.isAggressive()) {
                this.caveDweller.getLookControl().setLookAt((Entity)target, 90.0f, 90.0f);
            } else {
                this.caveDweller.getLookControl().setLookAt((Entity)target, 180.0f, 1.0f);
            }
        }
        this.caveDweller.getNavigation().moveTo(path, this.caveDweller.getSpeedModifier());
        if (!this.caveDweller.isCrawling()) {
            if (this.caveDweller.isAggressive()) {
                this.caveDweller.getLookControl().setLookAt((Entity)target, 90.0f, 90.0f);
            } else {
                this.caveDweller.getLookControl().setLookAt((Entity)target, 180.0f, 1.0f);
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        double distance = this.caveDweller.distanceToSqr((Entity)target);
        this.checkAndPerformAttack(target, distance);
        --this.ticksUntilLeave;
        if (this.speedUp < this.maxSpeedReached) {
            ++this.speedUp;
        }
    }

    private void fixPath(Path path) {
        LivingEntity target = this.caveDweller.getTarget();
        if (target == null) {
            return;
        }
        if (this.shouldClimb(path) && (double)path.getNode(0).distanceTo(this.caveDweller.getTarget().blockPosition()) > 0.1) {
            path.replaceNode(0, path.getNode(0).cloneAndMove(target.blockPosition().getX(), target.blockPosition().getY(), target.blockPosition().getZ()));
        }
    }

    private boolean shouldClimb(Path path) {
        if (this.caveDweller.getTarget() == null) {
            return false;
        }
        return path != null && path.getNodeCount() == 1 && (double)this.caveDweller.getTarget().blockPosition().getY() > (double)this.caveDweller.blockPosition().getY() + this.caveDweller.getAttributeValue(Attributes.STEP_HEIGHT);
    }

    private void checkAndPerformAttack(LivingEntity target, double distanceToTarget) {
        double attackReach = this.getAttackReachSqr(target);
        if (distanceToTarget <= attackReach && this.ticksUntilNextAttack <= 0) {
            Player player;
            this.resetAttackCooldown();
            this.caveDweller.swing(InteractionHand.MAIN_HAND);
            if (target instanceof Player) {
                player = (Player)target;
                this.specialHurt((LivingEntity)player, (float)this.caveDweller.getAttributeValue(Attributes.ATTACK_DAMAGE));
            } else {
                this.caveDweller.doHurtTarget((Entity)target);
            }
            if (((Boolean)ServerConfig.CAN_DISABLE_SHIELDS.get()).booleanValue() && target instanceof Player && (player = (Player)target).isBlocking()) {
                player.disableShield();
            }
        }
    }

    private void specialHurt(LivingEntity entity, float damage) {
        float currentHealth = entity.getHealth();
        float damagedHealth = Math.max(0.0f, currentHealth - damage);
        if (!entity.isBlocking()) {
            entity.setHealth(damagedHealth);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.playHurtSound(player);
            }
        }
        entity.hurtMarked = true;
    }

    private void playHurtSound(Player player) {
        player.level().playSound(null, player.blockPosition(), SoundEvents.PLAYER_HURT, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(20);
    }

    private double getAttackReachSqr(LivingEntity target) {
        return this.caveDweller.getBbWidth() * 4.0f * this.caveDweller.getBbWidth() * 4.0f + target.getBbWidth();
    }
}

