/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.server.goals;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import pt.gif.cave_dweller.core.util.Utils;
import pt.gif.cave_dweller.server.entities.CaveDwellerEntity;
import pt.gif.cave_dweller.server.goals.Roll;

public class CaveDwellerStareGoal
extends Goal {
    private final CaveDwellerEntity caveDweller;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public CaveDwellerStareGoal(CaveDwellerEntity caveDweller) {
        this.caveDweller = caveDweller;
        this.lookedAtMax = caveDweller.getRandom().nextIntBetweenInclusive(4, 13);
    }

    public boolean canUse() {
        if (this.caveDweller.isInvisible()) {
            return false;
        }
        if (!Utils.isValidTarget((Entity)this.caveDweller.getTarget())) {
            return false;
        }
        return this.caveDweller.currentRoll == Roll.STARE;
    }

    public boolean canContinueToUse() {
        if (!Utils.isValidTarget((Entity)this.caveDweller.getTarget())) {
            return false;
        }
        return this.caveDweller.currentRoll == Roll.STARE;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void stop() {
        super.stop();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.caveDweller.pleaseStopMoving = false;
        this.caveDweller.setSpotted(false);
    }

    public void tick() {
        boolean actuallyLooking;
        LivingEntity target = this.caveDweller.getTarget();
        if (target == null) {
            this.caveDweller.disappear();
            return;
        }
        boolean bl = actuallyLooking = this.caveDweller.targetIsFacingMe && target.hasLineOfSight((Entity)this.caveDweller);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax) {
            if (!actuallyLooking && this.caveDweller.getRandom().nextDouble() < 0.1) {
                this.caveDweller.disappear();
            } else if (this.caveDweller.getRandom().nextDouble() < 0.3) {
                this.caveDweller.pickRoll(List.of(Roll.CHASE, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.caveDweller.pleaseStopMoving = false;
            this.caveDweller.getNavigation().moveTo((Entity)target, 1.0);
        } else {
            this.caveDweller.pleaseStopMoving = true;
            this.caveDweller.getNavigation().stop();
            this.caveDweller.setDeltaMovement(Vec3.ZERO);
        }
        this.caveDweller.getLookControl().setLookAt((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

