/*
 * Decompiled with CFR 0.152.
 */
package pt.gif.cave_dweller.server.goals;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import pt.gif.cave_dweller.core.util.Utils;
import pt.gif.cave_dweller.server.entities.CaveDwellerEntity;
import pt.gif.cave_dweller.server.goals.Roll;

public class CaveDwellerTargetSeesMeGoal
extends NearestAttackableTargetGoal<Player> {
    private final CaveDwellerEntity caveDweller;

    public CaveDwellerTargetSeesMeGoal(CaveDwellerEntity mob) {
        super((Mob)mob, Player.class, true);
        this.caveDweller = mob;
    }

    public boolean canUse() {
        if (this.caveDweller.isInvisible()) {
            return false;
        }
        this.target = Utils.getValidTarget(this.caveDweller);
        if (!Utils.isValidTarget((Entity)this.target)) {
            return false;
        }
        return this.caveDweller.isLookingAtMe((Entity)this.target, true);
    }

    public void start() {
        this.caveDweller.setTarget(this.target);
        this.caveDweller.setSpotted(true);
        if (this.target != null) {
            this.caveDweller.pickRoll(List.of(Roll.CHASE, Roll.STARE, Roll.STARE, Roll.FLEE));
        }
        super.start();
    }

    public void stop() {
        super.stop();
    }

    public boolean canContinueToUse() {
        return Utils.isValidTarget((Entity)this.target);
    }

    public void tick() {
        super.tick();
    }
}

