# Mob Heads

<div style="display: flex; gap: 20px;">
<a href="https://ko-fi.com/H2H011LYHJ"><img src="https://ko-fi.com/img/githubbutton_sm.svg" alt="ko-fi"/></a>
  
<a href="https://github.com/sponsors/Jodekq" target="_blank">
  <img src="https://img.shields.io/badge/Sponsor-Jodek-green?style=for-the-badge&logo=github&logoWidth=20" alt="Sponsor @Jodek" />
</a>
</div>

<picture>
   <source media="(prefers-color-scheme: light)" srcset="https://raw.githubusercontent.com/Mqxx/GitHub-Markdown/main/blockquotes/badge/light-theme/tip.svg">
  <img alt="Tip" src="https://raw.githubusercontent.com/Mqxx/GitHub-Markdown/main/blockquotes/badge/dark-theme/tip.svg">
</picture>
 
Questions or issues? -> [discord server](https://discord.gg/z2n3qTzQY6) | _or create an issue on github_

## Features
**1.** Adds a head for every mob and mob variant in the game
--> over 300 different heads

**2.** Custom sound for all heads when placed on note blocks

**3.** Config to choose if heads drop when the mob was killed by a player or killed by a charged creeper

**4.** [Custom chat notifications when a head drops](#to-change-drop-rates-rarities-and-drop-messages:~:text=To%20change%20drop%20rates%2C%20rarities%20and%20drop%20messages)

**5.** [Easy to use config for drop rates and rarities](#to-change-drop-rates-rarities-and-drop-messages:~:text=To%20change%20drop%20rates%2C%20rarities%20and%20drop%20messages)

**6.** [1.21.6+] Get heads with `/trigger get_mob_head`

**7.** [1.21.5+] Advancement collection to see what heads you've collected (updates when you pick up a head) 

**Looting doesn't affect the drop rates**

[Default Drop Rates](https://modrinth.com/datapack/mob-heads#:~:text=run%20/reload%20afterwards-,Default%20drop%20rates,-%23)

## Showcase

<iframe width="560" height="315" src="https://www.youtube-nocookie.com/embed/xsZPlTAnR1E" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

## Config [1.21.6+]

### [1.21.6+] You can edit drop rates, rarities and drop massages ingame****

Run ingame: 

```
/trigger mobheads.config
```

---

### [1.21.5 and below] To change drop rates, rarities and drop messages

**make sure to unzip the datapack before**

Head to: `MobHeads/data/mobheads/function/config`

and then edit the specific folder (drop _rates.mcfunction , rarity.mcfunction , drop_messages.mcfunction)

don't forget to save the file and run /reload afterwards

## Default drop rates

| **#** | **Mob**                                         | **Drop Rate** |
|-------|-------------------------------------------------|---------------|
| 1     | Allay                                           | 1%            |
| 2     | Armadillo                                       | 1%            |
| 3     | Axolotl                                         | 1%            |
| 4     | Blue Axolotl                                    | 5%            |
| 5     | Bat                                             | 1%            |
| 6     | Bee                                             | 1%            |
| 7     | Blaze                                           | 0.5%          |
| 8     | Bogged                                          | 1%            |
| 9     | Breeze                                          | 1%            |
| 10    | Camel                                           | 2%            |
| 11    | Cat                                             | 2%            |
| 12    | Cave Spider                                     | 0.5%          |
| 13    | Chicken                                         | 0.1%          |
| 14    | Cod                                             | 0.1%          |
| 15    | Copper Golem                                    | 0.5%          |
| 16    | Cow                                             | 0.1%          |
| 17    | Creaking                                        | 0.1%          |
| 18    | Creeper                                         | 0.1%          |
| 19    | Charged Creeper                                 | 2%            |
| 20    | Dolphin                                         | 1%            |
| 21    | Donkey                                          | 1%            |
| 22    | Drowned                                         | 0.1%          |
| 23    | Elder Guardian                                  | 5%            |
| 24    | Ender Dragon                                    | 5%            |
| 25    | Enderman                                        | 0.1%          |
| 26    | Endermite                                       | 1%            |
| 27    | Evoker                                          | 1%            |
| 28    | Fox                                             | 1%            |
| 29    | Frog                                            | 1%            |
| 30    | Ghast                                           | 0.5%          |
| 31    | Glow Squid                                      | 1%            |
| 32    | Goat                                            | 1%            |
| 33    | Guardian                                        | 0.1%          |
| 34    | Happy Ghast                                     | 1%            |
| 35    | Hoglin                                          | 0.5%          |
| 36    | Horse                                           | 1%            |
| 37    | Husk                                            | 0.5%          |
| 38    | Illusioner                                      | 0.5%          |
| 39    | Iron Golem                                      | 0.5%          |
| 40    | Llama                                           | 1%            |
| 41    | Magma Cube                                      | 1%            |
| 42    | Mooshroom                                       | 1%            |
| 43    | Brown Mooshroom                                 | 2%            |
| 44    | Mule                                            | 1%            |
| 45    | Ozelot                                          | 1%            |
| 46    | Normal & Weak Panda                             | 1%            |
| 47    | Lazy, Brown, Playful, Aggressive, Worried Panda | 2%            |
| 48    | Parrot                                          | 1%            |
| 49    | Phantom                                         | 0.5%          |
| 50    | Pig                                             | 0.1%          |
| 51    | Pilgin Brute                                    | 2%            |
| 52    | Piglin                                          | 0.5%          |
| 53    | Pillager                                        | 0.1%          |
| 54    | Polar Bear                                      | 1%            |
| 55    | Pufferfish                                      | 1%            |
| 56    | Rabbit                                          | 1%            |
| 57    | Ravager                                         | 1%            |
| 58    | Salmon                                          | 0.5%          |
| 59    | Sheep                                           | 0.1%          |
| 60    | Shulker                                         | 1%            |
| 61    | Silverfish                                      | 0.1%          |
| 62    | Skeleton Horse                                  | 2%            |
| 63    | Skeleton                                        | 0.1%          |
| 64    | Slime                                           | 0.1%          |
| 65    | Sniffer                                         | 1%            |
| 66    | Snow Golem                                      | 0.1%          |
| 67    | Spider                                          | 0.1%          |
| 68    | Squid                                           | 0.5%          |
| 69    | Stray                                           | 0.5%          |
| 70    | Strider                                         | 1%            |
| 71    | Tadpole                                         | 1%            |
| 72    | Trader Llama                                    | 0.5%          |
| 73    | Tropical Fish                                   | 1%            |
| 74    | Turtle                                          | 1%            |
| 75    | Vex                                             | 1%            |
| 76    | Villager                                        | 1%            |
| 77    | Vindicator                                      | 0.5%          |
| 78    | Wandering Trader                                | 1%            |
| 79    | Warden                                          | 5%            |
| 80    | Witch                                           | 0.1%          |
| 81    | Wither                                          | 5%            |
| 82    | Special Wither Skull                            | 1%            |
| 83    | Wolf                                            | 1%            |
| 84    | Zoglin                                          | 1%            |
| 85    | Zombie Horse                                    | 1%            |
| 86    | Zombie Villager                                 | 3%            |
| 87    | Zombie                                          | 0.1%          |
| 88    | Zombified Piglin                                | 0.1%          |

## Guides

<picture>
   <source media="(prefers-color-scheme: light)" srcset="https://raw.githubusercontent.com/Mqxx/GitHub-Markdown/main/blockquotes/badge/light-theme/tip.svg">
  <img alt="Tip" src="https://raw.githubusercontent.com/Mqxx/GitHub-Markdown/main/blockquotes/badge/dark-theme/tip.svg">
 </picture><br>

 If something doesn't work, feel free to join the [discord server](https://discord.gg/z2n3qTzQY6)

<details>
  <summary>How to Install a Datapack in Singleplayer</summary>
  
  <details>
    <summary>At the Creation of a World</summary>

### How to install a datapack in singleplayer

1. **Open Minecraft**  
   Launch the game.

2. **Create a New World**  
   Navigate to "More" and click on **"Data Packs"**.

   ![Minecraft Settings Image](https://cdn.modrinth.com/data/cached_images/2dfe3c65a3471adb0ed85e36936ebcfc28dcaf95_0.webp)

3. **Add the Datapack**  
   Drag the datapack (a `.zip` file or directory) into the Minecraft window.

   - A confirmation screen will appear. Click **"Yes"**.

4. **Activate the Datapack**  
   Move the datapack to the right-hand side of the screen by clicking the triangle on its icon (visible when hovering over it).

![Minecraft Settings Image](https://cdn.modrinth.com/data/cached_images/7997495b82957b1f318b28f8de321508d6d43f19_0.webp)

5. **Complete World Creation**  
   - Click **"Done"** at the bottom of the screen.  
   - Continue creating your world and click **"Create New World"**.

---

### ⚠️ IMPORTANT ⚠️
The datapack only works if cheats are enabled.  

You can verify the datapack is active by typing:  
`/datapack list enabled`

This command should list an entry named `[file/<your datapack file/directory name>]`.
  </details>
  
  <details>
    <summary>In an Existing World</summary>

### How to Install a Datapack in an Existing Singleplayer World

1. **Open Minecraft**  
   Launch the game.

2. **Select Your World**  
   - Choose the world you want to install the datapack for.
   - Click **"Edit"**, then **"Open World Folder"**.

3. **Add the Datapack**  
   - Open the folder named `datapacks`.  
   - Place the datapack into this folder. It should be a `.zip` file or a directory.

4. **Reload the World**  
   - If you are in the world during installation, type `/reload` in the chat or press **F3 + T** to reload resources.  
   *(Make sure cheats are enabled.)*

---

### ⚠️ IMPORTANT ⚠️
The datapack only works if cheats are enabled.

You can verify the datapack is active by typing:  
`/datapack list enabled`
  </details>
  
  <details>
    <summary>How to Enable Cheats Permanently After World Creation</summary>

If you encounter this issue, here is a step by step guide on how to enable Cheats/Admincommands permanently after you have already created a Minecraft world.

⚠️ **Before you begin, you should save and backup your world in case something goes wrong.**  
(I will not take any responsibility for any corrupt worlds. Do this at your own risk!)  
But don't worry this works without any problems.  
If you don't want to change this permanently check out [this guide](#).

### 1. You need [NBTExplorer](https://github.com/jaquadro/NBTExplorer/releases/tag/v2.8.0-win)
> NBTExplorer is an open-source NBT editor for all common sources of NBT data. It's mainly intended for editing Minecraft game data.
 
### 2. Open NBTExplorer and open your Minecraft world, where you want to enable Cheats/Admincommands.

![NBTExplorer Image](https://cdn.discordapp.com/attachments/1270449267961757726/1270449504532955247/image.png?ex=674ea60d&is=674d548d&hm=dfabe212b0cb5c712f588e3c13e7ea33f5ee7040456cbead753f2e76b9dfa87f&)

### 3. Navigate to:
- `<Your Minecraft World>`
- `level.dat`
- `Data`
- `allowCommands`

![NBTExplorer Navigation Image](https://cdn.discordapp.com/attachments/1270449267961757726/1270449626478280865/image.png?ex=674ea62a&is=674d54aa&hm=cdf0691afe752b5b9b7312bd12e00681b1345428ce20352730690f676fe6006c&)

### 4. Click on **"Edit Tag Value"**

![Edit Tag Image](https://cdn.discordapp.com/attachments/1270449267961757726/1270449700583112907/image.png?ex=674ea63c&is=674d54bc&hm=eb3f6f389450078ce52e133b2f41eb90ccd20de61ccfda46fe3aa13d03e9a74e&)

### 5. Change the Value from `0` to `1` and click **"OK"**

![Change Value Image](https://cdn.discordapp.com/attachments/1270449267961757726/1270449791092002917/image.png?ex=674ea652&is=674d54d2&hm=c003c8ccd405c4197e40002ade6c9dc988ef52c43338f1c835672008010ca7a6&)

### 6. Now click on **"Save All Modified Tags"**

![Save Image](https://cdn.discordapp.com/attachments/1270449267961757726/1270450071997124638/image.png?ex=674ea694&is=674d5514&hm=791b00e3692832d9054e346700ca6e40976d9356f9d598830eed1dd42741f372&)

That's it. You are done. You can now join your world and check if you have permission to change your `gamemode`, for example.


  </details>
  
  <details>
    <summary>How to Enable Cheats Temporarily After World Creation</summary>

### Enabling Cheats Temporarily After World Creation

If you encounter this issue, here is a step-by-step guide on how to enable Cheats/Admin commands temporarily after you have already created a Minecraft world.

1. **Join Your World**  
   Open your single-player world and press "Escape".

2. **Open to LAN**  
   Click on **"Open to LAN"**.

   ![Open to LAN Screenshot](https://cdn.modrinth.com/data/cached_images/bc559370d9db9b5c1344bc808ba11d931c99aa29_0.webp)

3. **Allow Commands**  
   Set **"Allow Commands"** to **ON**.

   ![LAN World Minecraft Screen](https://cdn.modrinth.com/data/cached_images/97b9b61992b04acab2305b68c4dcf940498e4110_0.webp)

4. **Start LAN World**  
   Click **"Start LAN World"** to apply the changes.

![LAN World MC Screen](https://cdn.modrinth.com/data/cached_images/eb72b605a323cadcf7ef5dd629d1358417c8a42d_0.webp)

Now, you should be able to use commands like changing your gamemode. Keep in mind that this is only temporary and will need to be done every time you join the world.

  </details>
  
</details>

<details>
  <summary>How to Install a Datapack in Multiplayer</summary>

### How to Install a Datapack in Multiplayer

1. **Open Your Server Folder**  
   Navigate to your server folder, then open the folder for the world you wish to install the datapack in (default: `world`).

2. **Add the Datapack**  
   - The datapack should be a `.zip` file.  
   - Place the datapack into a folder named `datapacks` inside the world folder.

3. **Reload the Server**  
   - Type `/reload` from the console or as a level 3 operator if the server was running during the installation.
</details>
<details>
  <summary>How to Uninstall a Datapack</summary>


### How to Uninstall a Datapack from Your Singleplayer World or Server

1. **Run the Uninstall Command**  
   For my datapacks, run the command:  
   `/function datapack_name:uninstall`

2. **Delete the Datapack**  
   - Delete the datapack from the folder you placed it in.  
   - Alternatively, you can run:  
     `/datapack disable [file/your data pack file/directory name]`

3. **Reload the World or Server**  
   After deleting or disabling the datapack, run:  
   `/reload`
</details>
<details>
  <summary>How to Install a Mod on a Minecraft Server</summary>

### Step-by-Step Guide to Installing a Mod on a Minecraft Server

1. **Download the Mod**  
   - Make sure to download the **correct version** of the Mod that matches your server's Minecraft version.
   - **Important:** The mod file should be a `.jar` file.

2. **Ensure No Datapacks or Other Mods Conflict**  
   - Do not have both a datapack and a mod installed at the same time, as they may conflict.
   - Only install one or the other, depending on your server's setup.

3. **Locate the Mods Folder**  
   - Open your server's root directory.
   - Inside this directory, find the folder named `mods`.  
   - If the `mods` folder doesn't exist, create one.

4. **Install the Mod**  
   - Paste the downloaded `.jar` file for the Mod into the `mods` folder.

5. **Restart the Server**  
   - After adding the Mod to the `mods` folder, restart your Minecraft server for the mod to be activated.

6. **Verify Mod Installation**  
   - Once the server has restarted, join the server and check if the Mod is working.
   - You can use `/mods` or a similar command (depending on the mod) to see if the Mod has been successfully loaded.

### Additional Tips
- **Backup Your Server:** Always create a backup before installing the Mod to avoid data loss in case something goes wrong.
- **Ensure Mod Compatibility:** Check that the Mod is compatible with your Minecraft server version and any other mods you have installed.
</details>

## For anything pre (before) 1.21

<details>
<summary>Drop chances for 1.20.4 and 1.20.5-6</summary>

You can use <kbd>Ctrl</kbd> + <kbd>F</kbd> to search

### Common = 0.02 = 2%

- Chicken (1.21.5+: temperate, warm, cold)
- Cow (1.21.5+: temperate, warm, cold)
- Cave Spider
- Creeper
- Pig (1.21.5+: temperate, warm, cold)
- Sheep (different heads for all colors)
- Skeleton
- Spider
- Zombie
- Snow Golem
- Iron Golem

### Rare = 0.1 = 10 %
- Bat
- Bee
- Blaze
- Bogged
- Cod
- Donkey
- Drowned
- Enderman
- Evoker
- Frog (variants: cold, temperate, warm) 
- Glow Squid
- Guardian
- Hoglin
- Horse (variants: white, creamy, chestnut, brown, black, gray, dark_brown)
- Husk
- Llama (variants: white, creamy, gray, bronw)
- Magma Cube
- Mooshroom (variants: red, brown)
- Mule
- Phantom
- Piglin
- Pillager
- Pufferfish
- Salmon
- Slime
- Squid
- Tropical Fish 
- Villager (snow, savanna, plains, desert, jungle, taiga)
- Witch
- Wolf (woods, spotted, striped, snowy, rusty, pale, chestnut, black, ashen)

### Epic 0.2 = 20 % 
- Armadillo
- Allay
- Axolotl (variants: pink, wild, gold, cyan, blue)
- Breeze (1.20.5)
- Camel
- Cat (variants: all black, black, british shorthair, calico, jellie, persian, ragdoll, red, siamese, tabby, white)
- Dolphin
- Elder Guardian
- Endermite
- Fox (variants: red, snow)
- Ghast
- Goat
- Illusioner (not in game)
- Ocelot
- Parrot (variants: red, blue, cyan, gray, green)
- Piglin Brute
- Polar Bear
- Rabbit (variants: brown, white, gold, salt, black, white splotched, evil)
- Ravager
- Shulker
- Silverfish
- Skeleton Horse
- Stray
- Strider
- Trader Llama (variants: white, creamy, gray, bronw)
- Turtle
- Vex
- Vindicator
- Wandering Trader
- Zoglin
- Zombie Horse 
- Zombie Villager
- Zombified Piglin

### Legendary 0.3 = 30%
- Sniffer
- Warden
- Panda (variants: normal, lazy, worried, playful, weak, aggressive)


### Mythic 0.5 = 50%
- Enderdragon 
- Wither 
- Brown Panda

</details>

##

_In the datapack, you can edit these chances by changing the value in:_


```
data/minecraft/loot_tables/entities/entity.json
```


_in there, look for "conditions" and the condition "random_chance" and change the "chance" to the value in % you want the head to drop_



#

 <picture>
  <source media="(prefers-color-scheme: light)" srcset="https://raw.githubusercontent.com/Mqxx/GitHub-Markdown/main/blockquotes/badge/light-theme/info.svg">
   <img alt="Info" src="https://raw.githubusercontent.com/Mqxx/GitHub-Markdown/main/blockquotes/badge/dark-theme/info.svg">
</picture><br>

### Bug Fix for when you place down the heads, destroy them, and pick them up again:

[Keep Head Names Mod](https://modrinth.com/mod/keepheadnames)

This bug is fixed in 1.20.5

