/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.AuroraLogger;
import gg.auroramc.aurora.api.placeholder.PlaceholderHandler;
import gg.auroramc.levels.api.AuroraLevelsProvider;
import gg.auroramc.levels.api.data.LevelData;
import gg.auroramc.levels.command.CommandManager;
import gg.auroramc.levels.config.ConfigManager;
import gg.auroramc.levels.config.LevelConfig;
import gg.auroramc.levels.hooks.HookManager;
import gg.auroramc.levels.leveler.PlayerLeveler;
import gg.auroramc.levels.libs.bstats.bukkit.Metrics;
import gg.auroramc.levels.placeholder.LevelPlaceholderHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AuroraLevels
extends JavaPlugin {
    private PlayerLeveler leveler;
    private ConfigManager configManager;
    private CommandManager commandManager;
    private static AuroraLogger l;

    public static AuroraLogger logger() {
        return l;
    }

    public void onLoad() {
        this.configManager = new ConfigManager(this);
        l = AuroraAPI.createLogger((String)"AuroraLevels", () -> this.configManager.getLevelConfig().getDebug());
        HookManager.loadHooks(this);
        AuroraAPI.getLeaderboards().registerBoard("levels", user -> this.leveler.getTotalXpForLevel(((LevelData)user.getData(LevelData.class)).getLevel()) + ((LevelData)user.getData(LevelData.class)).getCurrentXP(), entry -> AuroraAPI.formatNumber((long)this.leveler.getLevelFromTotalXP(entry.getValue())), this.configManager.getLevelConfig().getLeaderboardCacheSize().intValue(), 1.0);
    }

    public void onEnable() {
        AuroraAPI.getUserManager().registerUserDataHolder(LevelData.class);
        this.leveler = new PlayerLeveler(this);
        AuroraAPI.registerPlaceholderHandler((PlaceholderHandler)new LevelPlaceholderHandler(this));
        this.commandManager = new CommandManager(this);
        this.commandManager.reload();
        try {
            Field field = AuroraLevelsProvider.class.getDeclaredField("plugin");
            field.setAccessible(true);
            field.set(null, (Object)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            l.severe("Failed to initialize api provider!");
            e.printStackTrace();
        }
        HookManager.enableHooks(this);
        Bukkit.getGlobalRegionScheduler().run((Plugin)this, task -> {
            LevelConfig config = this.configManager.getLevelConfig();
            this.leveler.getLevelMatcher().reload(config.getLevelMatchers(), config.getCustomLevels());
        });
        new Metrics(this, 23777);
    }

    public void reload() {
        this.configManager.reload();
        this.commandManager.reload();
        this.leveler.reload(false);
        ArrayList players = new ArrayList(Bukkit.getOnlinePlayers());
        CompletableFuture.runAsync(() -> {
            for (Player player : players) {
                if (!player.isOnline()) continue;
                this.leveler.correctCurrentXP(player);
                this.leveler.getRewardAutoCorrector().correctRewards(player);
            }
        });
    }

    public void onDisable() {
        this.commandManager.unregisterCommands();
    }

    public PlayerLeveler getLeveler() {
        return this.leveler;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

