/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.command;

import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.command.LevelCommand;
import gg.auroramc.levels.config.LevelConfig;
import gg.auroramc.levels.config.MessageConfig;
import gg.auroramc.levels.libs.acf.MessageKeys;
import gg.auroramc.levels.libs.acf.MinecraftMessageKeys;
import gg.auroramc.levels.libs.acf.PaperCommandManager;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.plugin.Plugin;

public class CommandManager {
    private final AuroraLevels plugin;
    private final PaperCommandManager commandManager;
    private final LegacyComponentSerializer serializer = ((LegacyComponentSerializer.Builder)LegacyComponentSerializer.legacyAmpersand().toBuilder()).hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    private boolean hasSetup = false;

    public CommandManager(AuroraLevels plugin) {
        this.commandManager = new PaperCommandManager((Plugin)plugin);
        this.plugin = plugin;
    }

    private void setupCommands() {
        if (!this.hasSetup) {
            this.commandManager.getLocales().setDefaultLocale(Locale.ENGLISH);
            this.commandManager.usePerIssuerLocale(false);
            LevelConfig.CommandAliasConfig aliases = this.plugin.getConfigManager().getLevelConfig().getCommandAliases();
            this.commandManager.getCommandReplacements().addReplacement("levelAlias", this.a(aliases.getLevel()));
            this.commandManager.getCommandReplacements().addReplacement("milestonesAlias", this.a(aliases.getMilestones()));
            this.commandManager.getCommandReplacements().addReplacement("setrawAlias", this.a(aliases.getSetraw()));
            this.commandManager.getCommandReplacements().addReplacement("setAlias", this.a(aliases.getSet()));
            this.commandManager.getCommandReplacements().addReplacement("addxpAlias", this.a(aliases.getAddxp()));
        }
        MessageConfig msg = this.plugin.getConfigManager().getMessageConfig();
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MinecraftMessageKeys.NO_PLAYER_FOUND, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MinecraftMessageKeys.NO_PLAYER_FOUND_OFFLINE, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MinecraftMessageKeys.NO_PLAYER_FOUND_SERVER, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MinecraftMessageKeys.IS_NOT_A_VALID_NAME, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.COULD_NOT_FIND_PLAYER, this.m(msg.getPlayerNotFound()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.PERMISSION_DENIED, this.m(msg.getNoPermission()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.PERMISSION_DENIED_PARAMETER, this.m(msg.getNoPermission()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.INVALID_SYNTAX, this.m(msg.getInvalidSyntax()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.MUST_BE_A_NUMBER, this.m(msg.getMustBeNumber()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.ERROR_PERFORMING_COMMAND, this.m(msg.getCommandError()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.ERROR_GENERIC_LOGGED, this.m(msg.getCommandError()));
        this.commandManager.getLocales().addMessage(Locale.ENGLISH, MessageKeys.NOT_ALLOWED_ON_CONSOLE, this.m(msg.getPlayerOnlyCommand()));
        if (!this.hasSetup) {
            this.commandManager.registerCommand(new LevelCommand(this.plugin));
            this.hasSetup = true;
        }
    }

    public void reload() {
        this.setupCommands();
    }

    private String a(List<String> aliases) {
        return String.join((CharSequence)"|", aliases);
    }

    private String m(String msg) {
        return this.serializer.serialize(Text.component((String)Chat.translateToMM((String)msg), (Placeholder[])new Placeholder[0]));
    }

    public void unregisterCommands() {
        this.commandManager.unregisterCommands();
    }
}

