/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.command;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.api.data.LevelData;
import gg.auroramc.levels.libs.acf.BaseCommand;
import gg.auroramc.levels.libs.acf.annotation.CommandAlias;
import gg.auroramc.levels.libs.acf.annotation.CommandCompletion;
import gg.auroramc.levels.libs.acf.annotation.CommandPermission;
import gg.auroramc.levels.libs.acf.annotation.Default;
import gg.auroramc.levels.libs.acf.annotation.Description;
import gg.auroramc.levels.libs.acf.annotation.Flags;
import gg.auroramc.levels.libs.acf.annotation.Subcommand;
import gg.auroramc.levels.menu.LevelMenu;
import gg.auroramc.levels.menu.MilestonesMenu;
import gg.auroramc.levels.menu.PaginatedLevelMenu;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="%levelAlias")
public class LevelCommand
extends BaseCommand {
    private final AuroraLevels plugin;

    public LevelCommand(AuroraLevels plugin) {
        this.plugin = plugin;
    }

    @Default
    @Description(value="Opens the level menu")
    @CommandPermission(value="aurora.levels.use")
    public void onMenu(Player player) {
        if (!player.hasPermission("aurora.levels.use.mainmenu")) {
            return;
        }
        if (!AuroraAPI.getUser((UUID)player.getUniqueId()).isLoaded()) {
            Chat.sendMessage((Player)player, (String)this.plugin.getConfigManager().getMessageConfig().getDataNotLoadedYetSelf(), (Placeholder[])new Placeholder[0]);
            return;
        }
        if (this.plugin.getConfigManager().getLevelMenuConfig().getUsePagination().booleanValue() && this.plugin.getConfigManager().getLevelConfig().getMaxLevel() != -1) {
            new PaginatedLevelMenu(this.plugin, player).open();
        } else {
            new LevelMenu(this.plugin, player).open();
        }
    }

    @Subcommand(value="info")
    @Description(value="Info about other player's leveling")
    @CommandCompletion(value="@players")
    @CommandPermission(value="aurora.levels.admin.info")
    public void onInfo(CommandSender sender, @Flags(value="other") Player player) {
        if (!AuroraAPI.getUser((UUID)player.getUniqueId()).isLoaded()) {
            Chat.sendMessage((Player)player, (String)this.plugin.getConfigManager().getMessageConfig().getDataNotLoadedYetSelf(), (Placeholder[])new Placeholder[0]);
            return;
        }
        LevelData data = this.plugin.getLeveler().getUserData(player);
        Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getInfo(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{player}", (String)player.getName()), Placeholder.of((String)"{level}", (Number)data.getLevel()), Placeholder.of((String)"{current_xp}", (Number)data.getCurrentXP())});
    }

    @Subcommand(value="%milestonesAlias")
    @Description(value="Opens the milestones menu")
    @CommandPermission(value="aurora.levels.milestones.use")
    public void onMilestonesMenu(Player player) {
        if (!AuroraAPI.getUser((UUID)player.getUniqueId()).isLoaded()) {
            Chat.sendMessage((Player)player, (String)this.plugin.getConfigManager().getMessageConfig().getDataNotLoadedYetSelf(), (Placeholder[])new Placeholder[0]);
            return;
        }
        new MilestonesMenu(this.plugin, player).open();
    }

    @Subcommand(value="%setAlias")
    @Description(value="Sets the level of a player")
    @CommandCompletion(value="@range:1-1000 @players true|false")
    @CommandPermission(value="aurora.levels.admin.set")
    public void onSetLevel(CommandSender sender, int level, @Flags(value="other") Player player, @Default(value="false") boolean silent) {
        if (!AuroraAPI.getUser((UUID)player.getUniqueId()).isLoaded()) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getDataNotLoadedYet(), (Placeholder[])new Placeholder[0]);
            return;
        }
        this.plugin.getLeveler().setPlayerLevel(player, level);
        if (!silent) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getLevelSet(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{level}", (Number)level), Placeholder.of((String)"{player}", (String)player.getName())});
            Chat.sendMessage((Player)player, (String)this.plugin.getConfigManager().getMessageConfig().getLevelSetTarget(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{level}", (Number)level)});
        }
    }

    @Subcommand(value="%setrawAlias")
    @Description(value="Sets the experience of a player without changing total experience structure")
    @CommandCompletion(value="@range:0-1000 @players true|false")
    @CommandPermission(value="aurora.levels.admin.setraw")
    public void onSetRaw(CommandSender sender, int level, @Flags(value="other") Player player, @Default(value="false") boolean silent) {
        if (!AuroraAPI.getUser((UUID)player.getUniqueId()).isLoaded()) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getDataNotLoadedYet(), (Placeholder[])new Placeholder[0]);
            return;
        }
        this.plugin.getLeveler().setPlayerLevelRaw(player, level);
        if (!silent) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getLevelSet(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{level}", (Number)level), Placeholder.of((String)"{player}", (String)player.getName())});
            Chat.sendMessage((Player)player, (String)this.plugin.getConfigManager().getMessageConfig().getLevelSetTarget(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{level}", (Number)level)});
        }
    }

    @Subcommand(value="%addxpAlias")
    @Description(value="Adds experience to a player")
    @CommandCompletion(value="@range:1-1000 @players true|false")
    @CommandPermission(value="aurora.levels.admin.addxp")
    public void onAddXp(CommandSender sender, double xp, @Flags(value="other") Player player, @Default(value="false") boolean silent) {
        if (!AuroraAPI.getUser((UUID)player.getUniqueId()).isLoaded()) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getDataNotLoadedYet(), (Placeholder[])new Placeholder[0]);
            return;
        }
        double added = this.plugin.getLeveler().addXpToPlayer(player, xp);
        if (!silent) {
            Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getXpAddedFeedback(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{amount}", (Number)added), Placeholder.of((String)"{player}", (String)player.getName())});
        }
    }

    @Subcommand(value="reload")
    @Description(value="Reloads level configurations")
    @CommandPermission(value="aurora.levels.admin.reload")
    public void onReload(CommandSender sender) {
        this.plugin.reload();
        Chat.sendMessage((CommandSender)sender, (String)this.plugin.getConfigManager().getMessageConfig().getReloaded(), (Placeholder[])new Placeholder[0]);
    }
}

