/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.config;

import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.config.LevelConfig;
import gg.auroramc.levels.config.MessageConfig;
import gg.auroramc.levels.config.menu.LevelMenuConfig;
import gg.auroramc.levels.config.menu.MilestoneMenuConfig;

public class ConfigManager {
    private LevelConfig levelConfig;
    private MessageConfig messageConfig;
    private LevelMenuConfig levelMenuConfig;
    private MilestoneMenuConfig milestoneMenuConfig;
    private final AuroraLevels plugin;

    public ConfigManager(AuroraLevels plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        LevelConfig.saveDefault(this.plugin);
        this.levelConfig = new LevelConfig(this.plugin);
        this.levelConfig.load();
        MessageConfig.saveDefault(this.plugin, this.levelConfig.getLanguage());
        this.messageConfig = new MessageConfig(this.plugin, this.levelConfig.getLanguage());
        this.messageConfig.load();
        LevelMenuConfig.saveDefault(this.plugin);
        this.levelMenuConfig = new LevelMenuConfig(this.plugin);
        this.levelMenuConfig.load();
        MilestoneMenuConfig.saveDefault(this.plugin);
        this.milestoneMenuConfig = new MilestoneMenuConfig(this.plugin);
        this.milestoneMenuConfig.load();
    }

    public LevelConfig getLevelConfig() {
        return this.levelConfig;
    }

    public MessageConfig getMessageConfig() {
        return this.messageConfig;
    }

    public LevelMenuConfig getLevelMenuConfig() {
        return this.levelMenuConfig;
    }

    public MilestoneMenuConfig getMilestoneMenuConfig() {
        return this.milestoneMenuConfig;
    }

    public AuroraLevels getPlugin() {
        return this.plugin;
    }
}

