/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.config;

import gg.auroramc.aurora.api.config.AuroraConfig;
import gg.auroramc.aurora.api.config.premade.ConcreteMatcherConfig;
import gg.auroramc.aurora.api.config.premade.IntervalMatcherConfig;
import gg.auroramc.levels.AuroraLevels;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.configuration.file.YamlConfiguration;

public class LevelConfig
extends AuroraConfig {
    private Boolean debug = false;
    private String language = "en";
    private String xpFormula;
    private Map<String, String> formulaPlaceholders;
    private Map<String, DisplayComponent> displayComponents;
    private LevelUpMessage levelUpMessage;
    private LevelUpTitle levelUpTitle;
    private XpGainActionBar xpGainActionBar;
    private LevelUpSound levelUpSound;
    private Map<String, IntervalMatcherConfig> levelMatchers;
    private Map<String, ConcreteMatcherConfig> customLevels;
    private CommandAliasConfig commandAliases;
    private Map<String, String> iconGenerator;
    private Integer leaderboardCacheSize = 10;
    private Integer maxLevel = -1;

    public LevelConfig(AuroraLevels plugin) {
        super(LevelConfig.getFile(plugin));
    }

    public static File getFile(AuroraLevels plugin) {
        return new File(plugin.getDataFolder(), "config.yml");
    }

    public static void saveDefault(AuroraLevels plugin) {
        if (!LevelConfig.getFile(plugin).exists()) {
            plugin.saveResource("config.yml", false);
        }
    }

    protected List<Consumer<YamlConfiguration>> getMigrationSteps() {
        return List.of(yaml -> {
            yaml.set("leaderboard-cache-size", (Object)10);
            yaml.setComments("leaderboard-cache-size", List.of("This only affects placeholder generation, like %aurora_lb_levels_name_10% and %aurora_lb_levels_fvalue_10%"));
            yaml.set("config-version", null);
            yaml.set("config-version", (Object)1);
        }, yaml -> {
            yaml.set("icon-generator", Map.of("0", "%any_placeholder_here%", "1", "%oraxen_number1%", "2", "any character, text here", "50", "same"));
            yaml.set("config-version", null);
            yaml.set("config-version", (Object)2);
        }, yaml -> {
            yaml.set("level-up-message.open-menu-when-clicked", (Object)false);
            yaml.set("config-version", null);
            yaml.set("config-version", (Object)3);
        }, yaml -> {
            yaml.set("config-version", null);
            yaml.set("max-level", (Object)-1);
            yaml.setComments("max-level", List.of("Maximum level that can be achieved, use -1 for no limit"));
            yaml.set("config-version", (Object)4);
        }, yaml -> {
            yaml.set("config-version", null);
            yaml.set("level-up-sound.sound", (Object)"entity.player.levelup");
            yaml.set("config-version", (Object)5);
        }, yaml -> {
            yaml.set("config-version", null);
            String ogFormula = yaml.getString("xp-formula", "level * 100");
            yaml.set("xp-formula", (Object)("(" + ogFormula.replaceAll("level", "(level)") + ") - (" + ogFormula.replaceAll("level", "(level - 1)") + ")"));
            yaml.set("config-version", (Object)6);
        });
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getXpFormula() {
        return this.xpFormula;
    }

    public Map<String, String> getFormulaPlaceholders() {
        return this.formulaPlaceholders;
    }

    public Map<String, DisplayComponent> getDisplayComponents() {
        return this.displayComponents;
    }

    public LevelUpMessage getLevelUpMessage() {
        return this.levelUpMessage;
    }

    public LevelUpTitle getLevelUpTitle() {
        return this.levelUpTitle;
    }

    public XpGainActionBar getXpGainActionBar() {
        return this.xpGainActionBar;
    }

    public LevelUpSound getLevelUpSound() {
        return this.levelUpSound;
    }

    public Map<String, IntervalMatcherConfig> getLevelMatchers() {
        return this.levelMatchers;
    }

    public Map<String, ConcreteMatcherConfig> getCustomLevels() {
        return this.customLevels;
    }

    public CommandAliasConfig getCommandAliases() {
        return this.commandAliases;
    }

    public Map<String, String> getIconGenerator() {
        return this.iconGenerator;
    }

    public Integer getLeaderboardCacheSize() {
        return this.leaderboardCacheSize;
    }

    public Integer getMaxLevel() {
        return this.maxLevel;
    }

    public static final class LevelUpMessage {
        private Boolean enabled;
        private Boolean openMenuWhenClicked = false;
        private List<String> message;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public Boolean getOpenMenuWhenClicked() {
            return this.openMenuWhenClicked;
        }

        public List<String> getMessage() {
            return this.message;
        }
    }

    public static final class LevelUpTitle {
        private Boolean enabled;
        private String title;
        private String subtitle;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public String getTitle() {
            return this.title;
        }

        public String getSubtitle() {
            return this.subtitle;
        }
    }

    public static final class XpGainActionBar {
        private Boolean enabled;
        private String message;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static final class LevelUpSound {
        private Boolean enabled;
        private String sound;
        private Float volume;
        private Float pitch;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public String getSound() {
            return this.sound;
        }

        public Float getVolume() {
            return this.volume;
        }

        public Float getPitch() {
            return this.pitch;
        }
    }

    public static final class CommandAliasConfig {
        private List<String> level = List.of("level");
        private List<String> setraw = List.of("setraw");
        private List<String> set = List.of("set");
        private List<String> addxp = List.of("addxp");
        private List<String> milestones = List.of("milestones");

        public List<String> getLevel() {
            return this.level;
        }

        public List<String> getSetraw() {
            return this.setraw;
        }

        public List<String> getSet() {
            return this.set;
        }

        public List<String> getAddxp() {
            return this.addxp;
        }

        public List<String> getMilestones() {
            return this.milestones;
        }
    }

    public static final class DisplayComponent {
        private String title;
        private String line;

        public String getTitle() {
            return this.title;
        }

        public String getLine() {
            return this.line;
        }
    }
}

