/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.config;

import gg.auroramc.aurora.api.config.AuroraConfig;
import gg.auroramc.levels.AuroraLevels;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageConfig
extends AuroraConfig {
    private String reloaded = "&aReloaded configuration!";
    private String levelSet = "&aLevel set to {level} for player {player}!";
    private String info = "&a{player} level is {level} and the current XP is {current_xp}!";
    private String levelSetTarget = "&aYour level was set to {level}!";
    private String xpAddedFeedback = "&a{amount} XP added to player {player}!";
    private String dataNotLoadedYet = "&cData for this player hasn't loaded yet, try again later!";
    private String dataNotLoadedYetSelf = "&cYour data isn't loaded yet, please try again later!";
    private String playerOnlyCommand = "&cThis command can only be executed by a player!";
    private String noPermission = "&cYou don't have permission to execute this command!";
    private String invalidSyntax = "&cInvalid command syntax!";
    private String mustBeNumber = "&cArgument must be a number!";
    private String playerNotFound = "&cPlayer not found!";
    private String commandError = "&cAn error occurred while executing this command!";
    private String regionEnterDenyMinLevel = "&cYou must be at least level {min-level} to enter this region!";
    private String regionEnterDenyMaxLevel = "&cYou must be at most level {max-level} to enter this region!";

    public MessageConfig(AuroraLevels plugin, String language) {
        super(MessageConfig.getFile(plugin, language));
    }

    private static File getFile(AuroraLevels plugin, String language) {
        return new File(plugin.getDataFolder(), "messages_" + language + ".yml");
    }

    public static void saveDefault(AuroraLevels plugin, String language) {
        if (!MessageConfig.getFile(plugin, language).exists()) {
            try {
                plugin.saveResource("messages_" + language + ".yml", false);
            }
            catch (Exception e) {
                AuroraLevels.logger().warning("Internal message file for language: " + language + " not found! Creating a new one from english...");
                File file = MessageConfig.getFile(plugin, language);
                try (InputStream in = plugin.getResource("messages_en.yml");){
                    Files.copy(in, file.toPath(), new CopyOption[0]);
                }
                catch (IOException ex) {
                    AuroraLevels.logger().severe("Failed to create message file for language: " + language);
                    ex.printStackTrace();
                }
            }
        }
    }

    protected List<Consumer<YamlConfiguration>> getMigrationSteps() {
        return List.of(yaml -> {
            yaml.set("region-enter-deny-min-level", (Object)"&cYou must be at least level {min-level} to enter this region!");
            yaml.set("region-enter-deny-max-level", (Object)"&cYou must be at most level {max-level} to enter this region!");
            yaml.set("config-version", null);
            yaml.set("config-version", (Object)1);
        }, yaml -> {
            yaml.set("config-version", null);
            yaml.set("info", (Object)"&a{player} level is {level} and the current XP is {current_xp}!");
            yaml.set("config-version", (Object)2);
        });
    }

    public String getReloaded() {
        return this.reloaded;
    }

    public String getLevelSet() {
        return this.levelSet;
    }

    public String getInfo() {
        return this.info;
    }

    public String getLevelSetTarget() {
        return this.levelSetTarget;
    }

    public String getXpAddedFeedback() {
        return this.xpAddedFeedback;
    }

    public String getDataNotLoadedYet() {
        return this.dataNotLoadedYet;
    }

    public String getDataNotLoadedYetSelf() {
        return this.dataNotLoadedYetSelf;
    }

    public String getPlayerOnlyCommand() {
        return this.playerOnlyCommand;
    }

    public String getNoPermission() {
        return this.noPermission;
    }

    public String getInvalidSyntax() {
        return this.invalidSyntax;
    }

    public String getMustBeNumber() {
        return this.mustBeNumber;
    }

    public String getPlayerNotFound() {
        return this.playerNotFound;
    }

    public String getCommandError() {
        return this.commandError;
    }

    public String getRegionEnterDenyMinLevel() {
        return this.regionEnterDenyMinLevel;
    }

    public String getRegionEnterDenyMaxLevel() {
        return this.regionEnterDenyMaxLevel;
    }
}

