/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.config.menu;

import gg.auroramc.aurora.api.config.AuroraConfig;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.levels.AuroraLevels;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.configuration.file.YamlConfiguration;

public class LevelMenuConfig
extends AuroraConfig {
    private String title;
    private List<Integer> levelTrack;
    private Integer rows = 6;
    private Boolean usePagination = false;
    private Boolean useItemAmounts = false;
    private Map<String, DisplayComponent> displayComponents;
    private Items items;
    private Map<String, ItemConfig> customItems;
    private ProgressBar progressBar;

    public LevelMenuConfig(AuroraLevels plugin) {
        super(LevelMenuConfig.getFile(plugin));
    }

    private static File getFile(AuroraLevels plugin) {
        return new File(plugin.getDataFolder(), "menus/levels.yml");
    }

    public static void saveDefault(AuroraLevels plugin) {
        if (!LevelMenuConfig.getFile(plugin).exists()) {
            plugin.saveResource("menus/levels.yml", false);
        }
    }

    protected List<Consumer<YamlConfiguration>> getMigrationSteps() {
        return List.of(yaml -> {
            yaml.set("config-version", null);
            int rows = yaml.getInt("rows", 6) - 1;
            yaml.set("items.next-page.name", (Object)"&fNext page");
            yaml.set("items.next-page.lore", List.of("&8Click to view the next page"));
            yaml.set("items.next-page.material", (Object)"ARROW");
            yaml.set("items.next-page.slot", (Object)(rows * 9 + 5));
            yaml.set("items.previous-page.name", (Object)"&fPrevious page");
            yaml.set("items.previous-page.lore", List.of("&8Click to view the previous page"));
            yaml.set("items.previous-page.material", (Object)"ARROW");
            yaml.set("items.previous-page.slot", (Object)(rows * 9 + 3));
            yaml.set("items.current-page.name", (Object)"&fPage {current}&7/&f{max}");
            yaml.set("items.current-page.material", (Object)"PAPER");
            yaml.set("items.current-page.slot", (Object)(rows * 9 + 4));
            yaml.set("use-pagination", (Object)false);
            yaml.set("use-item-amounts", (Object)false);
            yaml.set("config-version", (Object)1);
        });
    }

    public String getTitle() {
        return this.title;
    }

    public List<Integer> getLevelTrack() {
        return this.levelTrack;
    }

    public Integer getRows() {
        return this.rows;
    }

    public Boolean getUsePagination() {
        return this.usePagination;
    }

    public Boolean getUseItemAmounts() {
        return this.useItemAmounts;
    }

    public Map<String, DisplayComponent> getDisplayComponents() {
        return this.displayComponents;
    }

    public Items getItems() {
        return this.items;
    }

    public Map<String, ItemConfig> getCustomItems() {
        return this.customItems;
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public static final class Items {
        private FillerItem filler;
        private ItemConfig completedLevel;
        private ItemConfig nextLevel;
        private ItemConfig lockedLevel;
        private ItemConfig nextPage;
        private ItemConfig previousPage;
        private ItemConfig currentPage;

        public FillerItem getFiller() {
            return this.filler;
        }

        public ItemConfig getCompletedLevel() {
            return this.completedLevel;
        }

        public ItemConfig getNextLevel() {
            return this.nextLevel;
        }

        public ItemConfig getLockedLevel() {
            return this.lockedLevel;
        }

        public ItemConfig getNextPage() {
            return this.nextPage;
        }

        public ItemConfig getPreviousPage() {
            return this.previousPage;
        }

        public ItemConfig getCurrentPage() {
            return this.currentPage;
        }
    }

    public static final class ProgressBar {
        private Integer length = 20;
        private String filledCharacter;
        private String unfilledCharacter;

        public Integer getLength() {
            return this.length;
        }

        public String getFilledCharacter() {
            return this.filledCharacter;
        }

        public String getUnfilledCharacter() {
            return this.unfilledCharacter;
        }
    }

    public static final class FillerItem {
        private Boolean enabled;
        private ItemConfig item;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public ItemConfig getItem() {
            return this.item;
        }
    }

    public static final class DisplayComponent {
        private String title;
        private String line;

        public String getTitle() {
            return this.title;
        }

        public String getLine() {
            return this.line;
        }
    }
}

