/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.hooks;

import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.hooks.Hook;
import gg.auroramc.levels.hooks.Hooks;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class HookManager {
    private static final Map<Class<? extends Hook>, Hook> hooks = new HashMap<Class<? extends Hook>, Hook>();

    public static void enableHooks(AuroraLevels plugin) {
        for (Hook hook : hooks.values()) {
            hook.hook(plugin);
            if (!(hook instanceof Listener)) continue;
            Bukkit.getPluginManager().registerEvents((Listener)hook, (Plugin)plugin);
        }
    }

    public static void loadHooks(AuroraLevels plugin) {
        for (Hooks hook : Hooks.values()) {
            try {
                if (Bukkit.getPluginManager().getPlugin(hook.getPlugin()) == null) continue;
                Hook instance = hook.getClazz().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                instance.hookAtStartUp(plugin);
                hooks.put(hook.getClazz(), instance);
            }
            catch (Exception e) {
                AuroraLevels.logger().warning("Failed to hook " + hook.getPlugin() + ": " + e.getMessage());
            }
        }
    }

    public static <T extends Hook> T getHook(Class<T> clazz) {
        return (T)((Hook)clazz.cast(hooks.get(clazz)));
    }

    public static <T extends Hook> boolean isEnabled(Class<T> clazz) {
        return hooks.get(clazz) != null;
    }
}

