/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.hooks.auraskills;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.user.SkillsUser;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.api.data.LevelData;
import gg.auroramc.levels.hooks.auraskills.AuraSkillsStatReward;
import gg.auroramc.levels.leveler.PlayerLeveler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AuraSkillsCorrector
implements RewardCorrector {
    private final AuroraLevels plugin;
    private final Set<UUID> toLoad = Sets.newConcurrentHashSet();

    public AuraSkillsCorrector(AuroraLevels plugin) {
        this.plugin = plugin;
    }

    public void correctRewards(Player player) {
        if (AuraSkillsApi.get().getUser(player.getUniqueId()).isLoaded()) {
            AuroraLevels.logger().debug("User is already loaded by AuraSkills applying stat correctors immediately.");
            this.correctRewardsWhenLoaded(player, true);
        } else {
            this.toLoad.add(player.getUniqueId());
        }
    }

    public void correctRewardsWhenLoaded(Player player, boolean force) {
        if (!force && !this.toLoad.contains(player.getUniqueId())) {
            return;
        }
        this.toLoad.remove(player.getUniqueId());
        AuroraLevels.logger().debug("Correcting rewards for player: " + player.getName() + " was forced: " + force);
        PlayerLeveler leveler = this.plugin.getLeveler();
        LevelData data = leveler.getUserData(player);
        int level = data.getLevel();
        HashMap statMap = Maps.newHashMap();
        for (Stat stat : AuraSkillsApi.get().getGlobalRegistry().getStats()) {
            statMap.put(stat, 0.0);
        }
        for (int i = 1; i < level + 1; ++i) {
            LevelMatcher matcher = leveler.getLevelMatcher().getBestMatcher(i);
            if (matcher == null) continue;
            List<Placeholder<?>> formulaPlaceholders = leveler.getRewardFormulaPlaceholders(player, i);
            for (Reward reward : matcher.computeRewards(i)) {
                if (!(reward instanceof AuraSkillsStatReward)) continue;
                AuraSkillsStatReward statReward = (AuraSkillsStatReward)reward;
                statMap.merge(statReward.getStat(), statReward.getValue(formulaPlaceholders), Double::sum);
            }
        }
        if (!player.isOnline()) {
            return;
        }
        player.getScheduler().run((Plugin)this.plugin, task -> {
            for (Map.Entry entry : statMap.entrySet()) {
                String statKey = AuraSkillsStatReward.getAURA_SKILLS_STAT() + ((Stat)entry.getKey()).getId().toString();
                SkillsUser user = AuraSkillsApi.get().getUser(player.getUniqueId());
                StatModifier oldModifier = user.getStatModifier(statKey);
                if (oldModifier == null) {
                    if (!((Double)entry.getValue() > 0.0)) continue;
                    user.addStatModifier(new StatModifier(statKey, (Stat)entry.getKey(), ((Double)entry.getValue()).doubleValue()));
                    continue;
                }
                if ((Double)entry.getValue() <= 0.0) {
                    user.removeStatModifier(statKey);
                    continue;
                }
                if (((Double)entry.getValue()).doubleValue() == oldModifier.value()) continue;
                user.addStatModifier(new StatModifier(statKey, (Stat)entry.getKey(), ((Double)entry.getValue()).doubleValue()));
            }
        }, null);
    }
}

