/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.hooks.auraskills;

import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.stat.Stat;
import dev.aurelium.auraskills.api.stat.StatModifier;
import dev.aurelium.auraskills.api.user.SkillsUser;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.NumberReward;
import gg.auroramc.levels.AuroraLevels;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class AuraSkillsStatReward
extends NumberReward {
    private static final String AURA_SKILLS_STAT = "AURORA_LEVELS_";
    private Stat stat;

    public void execute(Player player, long level, List<Placeholder<?>> formulaPlaceholders) {
        if (this.stat == null) {
            return;
        }
        String modId = AURA_SKILLS_STAT + this.stat.getId().toString();
        double value = this.getValue(formulaPlaceholders);
        SkillsUser user = AuraSkillsApi.get().getUser(player.getUniqueId());
        StatModifier currentMod = user.getStatModifier(modId);
        if (currentMod != null) {
            value = currentMod.value() + value;
        }
        user.addStatModifier(new StatModifier(modId, this.stat, value));
    }

    public void init(ConfigurationSection args) {
        super.init(args);
        this.stat = AuraSkillsApi.get().getGlobalRegistry().getStat(NamespacedId.fromDefault((String)args.getString("stat", "invalid_stat")));
        if (this.stat == null) {
            AuroraLevels.logger().warning("Invalid stat in AuraSkillsStatReward: " + args.getString("stat"));
        }
    }

    public String getDisplay(Player player, List<Placeholder<?>> formulaPlaceholders) {
        String display = super.getDisplay(player, formulaPlaceholders);
        SkillsUser user = AuraSkillsApi.get().getUser(player.getUniqueId());
        return Placeholder.execute((String)display, (Placeholder[])new Placeholder[]{Placeholder.of((String)"{symbol}", (String)this.stat.getSymbol(user.getLocale())), Placeholder.of((String)"{stat}", (String)this.stat.getDisplayName(user.getLocale()))});
    }

    public static String getAURA_SKILLS_STAT() {
        return AURA_SKILLS_STAT;
    }

    public Stat getStat() {
        return this.stat;
    }
}

