/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.hooks.ecoskills;

import com.google.common.collect.Maps;
import com.willfp.ecoskills.api.EcoSkillsAPI;
import com.willfp.ecoskills.api.modifiers.ModifierOperation;
import com.willfp.ecoskills.api.modifiers.StatModifier;
import com.willfp.ecoskills.stats.Stat;
import com.willfp.ecoskills.stats.Stats;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.api.data.LevelData;
import gg.auroramc.levels.hooks.ecoskills.EcoSkillsStatReward;
import gg.auroramc.levels.leveler.PlayerLeveler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EcoSkillsCorrector
implements RewardCorrector {
    private final AuroraLevels plugin;

    public EcoSkillsCorrector(AuroraLevels plugin) {
        this.plugin = plugin;
    }

    public void correctRewards(Player player) {
        PlayerLeveler leveler = this.plugin.getLeveler();
        LevelData data = leveler.getUserData(player);
        int level = data.getLevel();
        HashMap statMap = Maps.newHashMap();
        Stats.INSTANCE.values().forEach(stat -> {
            Map map = statMap.computeIfAbsent(stat.getId(), key -> Maps.newHashMap());
            for (ModifierOperation operation : ModifierOperation.values()) {
                map.put(operation, 0.0);
            }
        });
        for (int i = 1; i < level + 1; ++i) {
            LevelMatcher matcher = leveler.getLevelMatcher().getBestMatcher(i);
            if (matcher == null) continue;
            List<Placeholder<?>> formulaPlaceholders = leveler.getRewardFormulaPlaceholders(player, i);
            for (Reward reward : matcher.computeRewards(i)) {
                EcoSkillsStatReward statReward;
                if (!(reward instanceof EcoSkillsStatReward) || !(statReward = (EcoSkillsStatReward)reward).isValid()) continue;
                statMap.computeIfAbsent(statReward.getStat().getId(), key -> Maps.newHashMap()).merge(statReward.getOperation(), statReward.getValue(formulaPlaceholders), Double::sum);
            }
        }
        player.getScheduler().run((Plugin)this.plugin, task -> {
            for (Map.Entry entry : statMap.entrySet()) {
                String statType = (String)entry.getKey();
                Stat stat = (Stat)Stats.INSTANCE.getByID(statType);
                if (stat == null) continue;
                for (Map.Entry modifierEntry : ((Map)entry.getValue()).entrySet()) {
                    ModifierOperation operation = (ModifierOperation)modifierEntry.getKey();
                    Double value = (Double)modifierEntry.getValue();
                    UUID uuid = EcoSkillsStatReward.createStatModifierUUID(stat, operation);
                    if (value <= 0.0) {
                        EcoSkillsAPI.removeStatModifier((Player)player, (UUID)uuid);
                        continue;
                    }
                    AuroraLevels.logger().debug("Adding stat " + statType + " with value " + value + "/" + operation.name() + " to player " + player.getName());
                    EcoSkillsAPI.addStatModifier((Player)player, (StatModifier)new StatModifier(uuid, stat, value.doubleValue(), operation));
                }
            }
        }, null);
    }
}

