/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.hooks.ecoskills;

import com.willfp.ecoskills.api.EcoSkillsAPI;
import com.willfp.ecoskills.api.modifiers.ModifierOperation;
import com.willfp.ecoskills.api.modifiers.StatModifier;
import com.willfp.ecoskills.stats.Stat;
import com.willfp.ecoskills.stats.Stats;
import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.NumberReward;
import gg.auroramc.levels.AuroraLevels;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class EcoSkillsStatReward
extends NumberReward {
    public static final String prefix = "aurora_levels/stat/";
    private boolean valid = true;
    private Stat stat;
    private ModifierOperation operation = ModifierOperation.ADD;

    private UUID createStatModifierUUID() {
        return EcoSkillsStatReward.createStatModifierUUID(this.stat, this.operation);
    }

    public static UUID createStatModifierUUID(Stat stat, ModifierOperation operation) {
        return UUID.nameUUIDFromBytes((prefix + stat.getId() + "/" + operation.name()).getBytes());
    }

    public void execute(Player player, long level, List<Placeholder<?>> placeholders) {
        if (!this.valid) {
            return;
        }
        UUID uuid = this.createStatModifierUUID();
        StatModifier current = EcoSkillsAPI.getStatModifier((Player)player, (UUID)uuid);
        double value = this.getValue(placeholders) + (current != null ? current.getModifier() : 0.0);
        EcoSkillsAPI.addStatModifier((Player)player, (StatModifier)new StatModifier(uuid, this.stat, value, this.operation));
    }

    public void init(ConfigurationSection args) {
        super.init(args);
        String statName = args.getString("stat", "");
        this.stat = (Stat)Stats.INSTANCE.getByID(statName);
        if (this.stat == null) {
            this.valid = false;
            AuroraLevels.logger().warning("Couldn't find EcoSkills stat: " + statName);
        }
        String operationName = args.getString("operation", "add").toUpperCase(Locale.ROOT);
        try {
            this.operation = ModifierOperation.valueOf((String)operationName);
        }
        catch (IllegalArgumentException e) {
            this.valid = false;
            AuroraLevels.logger().warning("Couldn't find EcoSkills operation: " + operationName);
        }
    }

    public String getDisplay(Player player, List<Placeholder<?>> placeholders) {
        String display = super.getDisplay(player, placeholders);
        if (!this.valid) {
            return display;
        }
        return Placeholder.execute((String)display, (Placeholder[])new Placeholder[]{Placeholder.of((String)"{stat}", (String)Chat.translateEverythingToMiniMessage((String)this.stat.getName()))});
    }

    public boolean isValid() {
        return this.valid;
    }

    public Stat getStat() {
        return this.stat;
    }

    public ModifierOperation getOperation() {
        return this.operation;
    }
}

