/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.hooks.luckperms;

import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.PermissionReward;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.api.data.LevelData;
import gg.auroramc.levels.leveler.PlayerLeveler;
import java.util.ArrayList;
import java.util.List;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeEqualityPredicate;
import net.luckperms.api.util.Tristate;
import org.bukkit.entity.Player;

public class PermissionCorrector
implements RewardCorrector {
    private AuroraLevels plugin;

    public PermissionCorrector(AuroraLevels plugin) {
        this.plugin = plugin;
    }

    public void correctRewards(Player player) {
        PlayerLeveler leveler = this.plugin.getLeveler();
        LevelData data = leveler.getUserData(player);
        int level = data.getLevel();
        ArrayList nodesToAdd = new ArrayList();
        for (int i = 1; i < level + 1; ++i) {
            LevelMatcher matcher = leveler.getLevelMatcher().getBestMatcher(i);
            if (matcher == null) continue;
            List<Placeholder<?>> formulaPlaceholders = leveler.getRewardFormulaPlaceholders(player, i);
            for (Reward reward : matcher.computeRewards(i)) {
                PermissionReward permissionReward;
                if (!(reward instanceof PermissionReward) || (permissionReward = (PermissionReward)reward).getPermissions() == null || permissionReward.getPermissions().isEmpty()) continue;
                List nodes = permissionReward.buildNodes(player, formulaPlaceholders);
                nodesToAdd.addAll(nodes);
            }
        }
        if (nodesToAdd.isEmpty()) {
            return;
        }
        User user = LuckPermsProvider.get().getUserManager().getUser(player.getUniqueId());
        if (user == null) {
            AuroraLevels.logger().severe("User " + player.getName() + " is not loaded in LuckPerms, failed to correct permission rewards!");
            return;
        }
        int addedNodes = 0;
        for (Node node : nodesToAdd) {
            Tristate hasPermission = user.data().contains(node, NodeEqualityPredicate.EXACT);
            if (!hasPermission.equals((Object)Tristate.UNDEFINED)) continue;
            AuroraLevels.logger().debug("Permission " + node.getKey() + " is undefined for player " + player.getName());
            user.data().add(node);
            ++addedNodes;
        }
        if (addedNodes > 0) {
            LuckPermsProvider.get().getUserManager().saveUser(user);
            AuroraLevels.logger().debug("Added " + addedNodes + " permission nodes to player " + player.getName());
        }
    }
}

