/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.hooks.mythic.reward;

import com.google.common.collect.Maps;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.api.data.LevelData;
import gg.auroramc.levels.hooks.mythic.reward.MythicStatReward;
import gg.auroramc.levels.leveler.PlayerLeveler;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public class MythicStatCorrector
implements RewardCorrector {
    private final AuroraLevels plugin;

    public MythicStatCorrector(AuroraLevels plugin) {
        this.plugin = plugin;
    }

    public void correctRewards(Player player) {
        PlayerLeveler leveler = this.plugin.getLeveler();
        LevelData data = leveler.getUserData(player);
        int level = data.getLevel();
        MythicBukkit mythic = MythicBukkit.inst();
        StatRegistry registry = ((PlayerData)mythic.getPlayerManager().getProfile(player)).getStatRegistry();
        HashMap statMap = Maps.newHashMap();
        mythic.getStatManager().getStats().values().forEach(statType -> {
            if (!statType.isEnabled()) {
                return;
            }
            registry.removeValue(statType, MythicStatReward.getSource());
        });
        for (int i = 1; i < level + 1; ++i) {
            LevelMatcher matcher = leveler.getLevelMatcher().getBestMatcher(i);
            if (matcher == null) continue;
            List<Placeholder<?>> formulaPlaceholders = leveler.getRewardFormulaPlaceholders(player, i);
            for (Reward reward : matcher.computeRewards(i)) {
                MythicStatReward statReward;
                if (!(reward instanceof MythicStatReward) || !(statReward = (MythicStatReward)reward).isValid()) continue;
                statMap.computeIfAbsent(statReward.getStatType(), key -> Maps.newHashMap()).merge(statReward.getModifierType(), statReward.getValue(formulaPlaceholders), Double::sum);
            }
        }
        for (Map.Entry entry : statMap.entrySet()) {
            StatType statType2 = (StatType)entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                StatModifierType modifierType = (StatModifierType)entry2.getKey();
                Double value = (Double)entry2.getValue();
                AuroraLevels.logger().debug("Adding stat " + statType2.getKey() + " with value " + value + " to player " + player.getName());
                registry.putValue(statType2, MythicStatReward.getSource(), modifierType, value.doubleValue());
            }
        }
    }
}

