/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.hooks.mythic.reward;

import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.reward.NumberReward;
import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.hooks.mythic.reward.AuroraStatSource;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.skills.stats.StatRegistry;
import io.lumine.mythic.core.skills.stats.StatSource;
import io.lumine.mythic.core.skills.stats.StatType;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MythicStatReward
extends NumberReward {
    private static final StatSource source = new AuroraStatSource();
    private StatType statType;
    private StatModifierType modifierType;
    private boolean valid = true;

    public void execute(Player player, long level, List<Placeholder<?>> placeholders) {
        if (!this.valid) {
            return;
        }
        StatRegistry registry = ((PlayerData)MythicBukkit.inst().getPlayerManager().getProfile(player)).getStatRegistry();
        if (registry.getStatData(this.statType).isPresent()) {
            StatRegistry.StatMap data = (StatRegistry.StatMap)registry.getStatData(this.statType).get();
            double current = 0.0;
            switch (this.modifierType) {
                case ADDITIVE: {
                    current = data.getAdditives().getOrDefault(source, 0.0);
                    break;
                }
                case ADDITIVE_MULTIPLIER: {
                    current = data.getAdditiveMultipliers().getOrDefault(source, 0.0);
                    break;
                }
                case COMPOUND_MULTIPLIER: {
                    current = data.getCompoundMultipliers().getOrDefault(source, 0.0);
                    break;
                }
                case SETTER: {
                    current = data.getSetters().getOrDefault(source, 0.0);
                }
            }
            registry.putValue(this.statType, source, this.modifierType, current + this.getValue(placeholders));
        } else {
            registry.putValue(this.statType, source, this.modifierType, this.getValue(placeholders).doubleValue());
        }
    }

    public void init(ConfigurationSection args) {
        super.init(args);
        String stat = args.getString("stat");
        if (stat == null) {
            this.valid = false;
            AuroraLevels.logger().warning("Stat is not defined in MythicStatReward");
            return;
        }
        this.statType = (StatType)MythicBukkit.inst().getStatManager().getStats().get(stat);
        if (this.statType == null) {
            this.valid = false;
            AuroraLevels.logger().warning("Invalid stat: " + stat + " in MythicStatReward");
            return;
        }
        if (!this.statType.isEnabled()) {
            this.valid = false;
            AuroraLevels.logger().warning("Stat: " + stat + " is not enabled in MythicMobs. Cannot create MythicStatReward.");
            return;
        }
        String modifier = args.getString("modifier", "additive");
        try {
            this.modifierType = StatModifierType.valueOf((String)modifier.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.valid = false;
            AuroraLevels.logger().warning("Invalid modifier type: " + modifier + " in MythicStatReward");
        }
    }

    public String getDisplay(Player player, List<Placeholder<?>> placeholders) {
        String display = super.getDisplay(player, placeholders);
        if (!this.valid) {
            return display;
        }
        Double value = this.getValue(placeholders);
        return Placeholder.execute((String)display, (Placeholder[])new Placeholder[]{Placeholder.of((String)"{stat}", (String)this.statType.getDisplay()), Placeholder.of((String)"{stat_display}", (String)this.statType.getFormattedValue(this.modifierType, value.doubleValue()))});
    }

    public StatType getStatType() {
        return this.statType;
    }

    public StatModifierType getModifierType() {
        return this.modifierType;
    }

    public boolean isValid() {
        return this.valid;
    }

    public static StatSource getSource() {
        return source;
    }
}

