/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.hooks.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.Handler;
import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.user.AuroraUser;
import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.api.data.LevelData;
import gg.auroramc.levels.config.MessageConfig;
import gg.auroramc.levels.hooks.worldguard.FlagManager;
import java.util.UUID;

public class EntryHandler
extends Handler {
    private final AuroraLevels plugin;

    public static Factory FACTORY(AuroraLevels plugin) {
        return new Factory(plugin);
    }

    protected EntryHandler(Session session, AuroraLevels plugin) {
        super(session);
        this.plugin = plugin;
    }

    public boolean testMoveTo(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, MoveType moveType) {
        if (this.getSession().getManager().hasBypass(player, (World)to.getExtent())) {
            return true;
        }
        AuroraUser user = AuroraAPI.getUser((UUID)player.getUniqueId());
        if (!user.isLoaded()) {
            return true;
        }
        MessageConfig config = this.plugin.getConfigManager().getMessageConfig();
        int level = ((LevelData)user.getData(LevelData.class)).getLevel();
        Integer minLevel = (Integer)toSet.queryValue((RegionAssociable)player, (Flag)FlagManager.MIN_LEVEL_FLAG);
        Integer maxLevel = (Integer)toSet.queryValue((RegionAssociable)player, (Flag)FlagManager.MAX_LEVEL_FLAG);
        org.bukkit.entity.Player bukkitPlayer = BukkitAdapter.adapt((Player)player);
        if (minLevel != null && level < minLevel) {
            Chat.sendMessage((org.bukkit.entity.Player)bukkitPlayer, (String)config.getRegionEnterDenyMinLevel(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{level}", (Number)level), Placeholder.of((String)"{min-level}", (Number)minLevel)});
            return false;
        }
        if (maxLevel != null && level > maxLevel) {
            Chat.sendMessage((org.bukkit.entity.Player)bukkitPlayer, (String)config.getRegionEnterDenyMaxLevel(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{level}", (Number)level), Placeholder.of((String)"{max-level}", (Number)maxLevel)});
            return false;
        }
        return true;
    }

    public static class Factory
    extends Handler.Factory<EntryHandler> {
        private final AuroraLevels plugin;

        public Factory(AuroraLevels plugin) {
            this.plugin = plugin;
        }

        public EntryHandler create(Session session) {
            return new EntryHandler(session, this.plugin);
        }
    }
}

