/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.leveler;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.events.user.AuroraUserLoadedEvent;
import gg.auroramc.aurora.api.expression.NumberExpression;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.levels.MatcherManager;
import gg.auroramc.aurora.api.message.ActionBar;
import gg.auroramc.aurora.api.message.Chat;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.message.TitleBar;
import gg.auroramc.aurora.api.reward.CommandReward;
import gg.auroramc.aurora.api.reward.ItemReward;
import gg.auroramc.aurora.api.reward.MoneyReward;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardAutoCorrector;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.aurora.api.reward.RewardExecutor;
import gg.auroramc.aurora.api.reward.RewardFactory;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.api.data.LevelData;
import gg.auroramc.levels.api.event.PlayerLevelUpEvent;
import gg.auroramc.levels.api.event.PlayerXpGainEvent;
import gg.auroramc.levels.api.leveler.Leveler;
import gg.auroramc.levels.config.LevelConfig;
import gg.auroramc.levels.reward.corrector.CommandCorrector;
import gg.auroramc.levels.util.RomanNumber;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PlayerLeveler
implements Leveler,
Listener {
    private final AuroraLevels plugin;
    private final Map<Integer, Double> levelXPCache = new ConcurrentHashMap<Integer, Double>();
    private final Map<Integer, Double> levelTotalXPCache = new ConcurrentHashMap<Integer, Double>();
    private final Map<String, ThreadLocal<NumberExpression>> formulas = new ConcurrentHashMap<String, ThreadLocal<NumberExpression>>();
    private final Map<String, Map<Integer, Double>> formulaCache = new ConcurrentHashMap<String, Map<Integer, Double>>();
    private final AtomicReference<MatcherManager> levelMatcher = new AtomicReference();
    private final RewardFactory rewardFactory = new RewardFactory();
    private final RewardAutoCorrector rewardAutoCorrector = new RewardAutoCorrector();
    private ThreadLocal<NumberExpression> xpFormula;
    private final Cache<Double, Integer> xpToLevelCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    @Override
    public MatcherManager getLevelMatcher() {
        return this.levelMatcher.get();
    }

    public PlayerLeveler(AuroraLevels plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
        this.rewardFactory.registerRewardType(NamespacedId.fromDefault((String)"command"), CommandReward.class);
        this.rewardFactory.registerRewardType(NamespacedId.fromDefault((String)"money"), MoneyReward.class);
        this.rewardFactory.registerRewardType(NamespacedId.fromDefault((String)"item"), ItemReward.class);
        this.levelMatcher.set(new MatcherManager(this.rewardFactory));
        this.rewardAutoCorrector.registerCorrector(NamespacedId.fromDefault((String)"command"), (RewardCorrector)new CommandCorrector(plugin));
        this.reload(true);
    }

    public void reload(boolean first) {
        LevelConfig config = this.plugin.getConfigManager().getLevelConfig();
        this.xpFormula = ThreadLocal.withInitial(() -> new NumberExpression(config.getXpFormula().replace("{level}", "level"), new String[]{"level"}));
        this.formulas.clear();
        for (Map.Entry<String, String> formula : config.getFormulaPlaceholders().entrySet()) {
            this.formulas.put(formula.getKey(), ThreadLocal.withInitial(() -> new NumberExpression(((String)formula.getValue()).replace("{level}", "level"), new String[]{"level"})));
        }
        this.levelXPCache.clear();
        this.levelTotalXPCache.clear();
        this.formulaCache.clear();
        this.xpToLevelCache.invalidateAll();
        if (!first) {
            this.levelMatcher.get().reload(config.getLevelMatchers(), config.getCustomLevels());
        }
    }

    @Override
    public LevelData getUserData(Player player) {
        return (LevelData)AuroraAPI.getUser((UUID)player.getUniqueId()).getData(LevelData.class);
    }

    @Override
    public double addXpToPlayer(Player player, double xp) {
        if (!player.hasPermission("aurora.levels.use")) {
            return 0.0;
        }
        LevelData data = this.getUserData(player);
        if (data.getLevel() >= this.getLevelCap()) {
            return 0.0;
        }
        PlayerXpGainEvent event = new PlayerXpGainEvent(player, xp);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return 0.0;
        }
        xp = event.getXp();
        double requiredXpToLevelUp = this.getRequiredXpForLevelUp(player);
        double newXP = data.getCurrentXP() + xp;
        if (this.plugin.getConfigManager().getLevelConfig().getXpGainActionBar().getEnabled().booleanValue()) {
            ActionBar.send((Player)player, (String)this.plugin.getConfigManager().getLevelConfig().getXpGainActionBar().getMessage(), (Placeholder[])new Placeholder[]{Placeholder.of((String)"{amount}", (String)AuroraAPI.formatNumber((double)xp))});
        }
        if (newXP < requiredXpToLevelUp) {
            data.setCurrentXP(newXP);
            AuroraAPI.getLeaderboards().updateUser(AuroraAPI.getUserManager().getUser(player), new String[]{"levels"});
            return xp;
        }
        while (newXP >= requiredXpToLevelUp) {
            if (data.getLevel() >= this.getLevelCap()) {
                data.setCurrentXP(0.0);
                break;
            }
            data.setLevel(data.getLevel() + 1);
            if (data.getLevel() < this.getLevelCap()) {
                data.setCurrentXP(newXP - requiredXpToLevelUp);
            }
            newXP = data.getCurrentXP();
            requiredXpToLevelUp = this.getRequiredXpForLevelUp(player);
            this.rewardPlayer(player, data.getLevel());
            Bukkit.getPluginManager().callEvent((Event)new PlayerLevelUpEvent(player, data.getLevel()));
        }
        AuroraAPI.getLeaderboards().updateUser(AuroraAPI.getUserManager().getUser(player), new String[]{"levels"});
        return xp;
    }

    @Override
    public List<Placeholder<?>> getRewardFormulaPlaceholders(Player player, int level) {
        LevelConfig config = this.plugin.getConfigManager().getLevelConfig();
        ArrayList formulaPlaceholders = new ArrayList();
        for (Map.Entry<String, String> formula : config.getFormulaPlaceholders().entrySet()) {
            double value = this.getFormulaValueForLevel(formula.getKey(), level);
            formulaPlaceholders.add(Placeholder.of((String)("{" + formula.getKey() + "}"), (Number)value));
            formulaPlaceholders.add(Placeholder.of((String)("{" + formula.getKey() + "_int}"), (Number)Double.valueOf(value).longValue()));
            formulaPlaceholders.add(Placeholder.of((String)("{" + formula.getKey() + "_formatted}"), (String)AuroraAPI.formatNumber((double)value)));
        }
        double totalRequiredXP = this.getXpForLevel(level);
        double totalXP = this.getTotalXpForLevel(this.getUserData(player).getLevel()) + this.getUserData(player).getCurrentXP();
        formulaPlaceholders.add(Placeholder.of((String)"{required_xp_total}", (String)AuroraAPI.formatNumber((double)totalRequiredXP)));
        formulaPlaceholders.add(Placeholder.of((String)"{required_xp_total_short}", (String)AuroraAPI.formatNumberShort((double)totalRequiredXP)));
        formulaPlaceholders.add(Placeholder.of((String)"{current_xp_total}", (String)AuroraAPI.formatNumber((double)totalXP)));
        formulaPlaceholders.add(Placeholder.of((String)"{current_xp_total_short}", (String)AuroraAPI.formatNumberShort((double)totalXP)));
        formulaPlaceholders.add(Placeholder.of((String)"{player}", (String)player.getName()));
        formulaPlaceholders.add(Placeholder.of((String)"{level}", (Number)level));
        formulaPlaceholders.add(Placeholder.of((String)"{level_int}", (Number)level));
        formulaPlaceholders.add(Placeholder.of((String)"{level_roman}", (String)RomanNumber.toRoman(level)));
        formulaPlaceholders.add(Placeholder.of((String)"{level_formatted}", (String)AuroraAPI.formatNumber((long)level)));
        return formulaPlaceholders;
    }

    private void rewardPlayer(Player player, int level) {
        LevelConfig config = this.plugin.getConfigManager().getLevelConfig();
        List<Placeholder<?>> placeholders = this.getRewardFormulaPlaceholders(player, level);
        placeholders.add(Placeholder.of((String)"{prev_level}", (Number)(level - 1)));
        placeholders.add(Placeholder.of((String)"{prev_level_int}", (Number)(level - 1)));
        placeholders.add(Placeholder.of((String)"{prev_level_formatted}", (String)AuroraAPI.formatNumber((long)(level - 1))));
        LevelMatcher matcher = this.levelMatcher.get().getBestMatcher(level);
        List rewards = matcher.computeRewards(level);
        RewardExecutor.execute((List)rewards, (Player)player, (long)level, placeholders);
        if (config.getLevelUpSound().getEnabled().booleanValue()) {
            LevelConfig.LevelUpSound sound = config.getLevelUpSound();
            NamespacedKey key = NamespacedKey.fromString((String)sound.getSound());
            if (key != null) {
                Sound realSound = (Sound)Registry.SOUNDS.get(key);
                if (realSound != null) {
                    player.playSound(player.getLocation(), realSound, sound.getVolume().floatValue(), sound.getPitch().floatValue());
                }
            } else {
                AuroraLevels.logger().warning("Invalid sound key: " + sound.getSound());
            }
        }
        if (config.getLevelUpMessage().getEnabled().booleanValue()) {
            TextComponent.Builder text = Component.text();
            List<String> messageLines = config.getLevelUpMessage().getMessage();
            int count = 0;
            for (String line : messageLines) {
                ++count;
                if (line.equals("component:rewards")) {
                    if (!rewards.isEmpty()) {
                        text.append(Text.component((Player)player, (String)config.getDisplayComponents().get("rewards").getTitle(), placeholders));
                    }
                    for (Reward reward : rewards) {
                        text.append((Component)Component.newline());
                        String display = config.getDisplayComponents().get("rewards").getLine().replace("{reward}", reward.getDisplay(player, placeholders));
                        text.append(Text.component((Player)player, (String)display, placeholders));
                    }
                } else {
                    text.append(Text.component((Player)player, (String)line, placeholders));
                }
                if (count == messageLines.size()) continue;
                text.append((Component)Component.newline());
            }
            if (config.getLevelUpMessage().getOpenMenuWhenClicked().booleanValue()) {
                text.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/" + config.getCommandAliases().getLevel().get(0))));
            }
            Chat.sendMessage((Player)player, (Component)text.build());
        }
        if (config.getLevelUpTitle().getEnabled().booleanValue()) {
            TitleBar.send((Player)player, (String)config.getLevelUpTitle().getTitle(), (String)config.getLevelUpTitle().getSubtitle(), placeholders);
        }
    }

    public int getLevelCap() {
        if (this.plugin.getConfigManager().getLevelConfig().getMaxLevel() == -1) {
            return Integer.MAX_VALUE;
        }
        return this.plugin.getConfigManager().getLevelConfig().getMaxLevel();
    }

    @Override
    public void setPlayerLevel(Player player, int level) {
        level = Math.min(level, this.getLevelCap());
        LevelData data = this.getUserData(player);
        data.setCurrentXP(0.0);
        if (data.getLevel() == level) {
            return;
        }
        if (data.getLevel() > level) {
            data.setLevel(level);
            Bukkit.getPluginManager().callEvent((Event)new PlayerLevelUpEvent(player, level));
            AuroraAPI.getLeaderboards().updateUser(AuroraAPI.getUserManager().getUser(player), new String[]{"levels"});
            return;
        }
        for (int l = data.getLevel() + 1; l <= level; ++l) {
            data.setLevel(l);
            this.rewardPlayer(player, l);
            Bukkit.getPluginManager().callEvent((Event)new PlayerLevelUpEvent(player, level));
        }
        AuroraAPI.getLeaderboards().updateUser(AuroraAPI.getUserManager().getUser(player), new String[]{"levels"});
    }

    @Override
    public void setPlayerLevelRaw(Player player, int level) {
        level = Math.min(level, this.getLevelCap());
        LevelData data = this.getUserData(player);
        data.setCurrentXP(0.0);
        data.setLevel(level);
        AuroraAPI.getLeaderboards().updateUser(AuroraAPI.getUserManager().getUser(player), new String[]{"levels"});
    }

    @Override
    public double getXpForLevel(int level) {
        if (level == 0) {
            return 0.0;
        }
        Double cached = this.levelXPCache.get(level);
        if (cached != null) {
            return cached;
        }
        double value = this.xpFormula.get().evaluate(new Placeholder[]{Placeholder.of((String)"level", (Number)level)});
        this.levelXPCache.put(level, value);
        return value;
    }

    public double getTotalXpForLevel(int level) {
        if (level <= 0) {
            return 0.0;
        }
        Double cached = this.levelTotalXPCache.get(level);
        if (cached != null) {
            return cached;
        }
        int lastCached = this.levelTotalXPCache.getOrDefault(-1, 0.0).intValue();
        double total = this.levelTotalXPCache.getOrDefault(lastCached, 0.0);
        for (int i = lastCached + 1; i <= level; ++i) {
            this.levelTotalXPCache.put(i, total += this.getXpForLevel(i));
        }
        this.levelTotalXPCache.put(-1, Double.valueOf(level));
        return total;
    }

    public int getLevelFromTotalXP(double currentXp) {
        return (Integer)this.xpToLevelCache.get((Object)currentXp, () -> {
            int low = 0;
            int high = 1;
            while (this.getTotalXpForLevel(high) <= currentXp) {
                low = high;
                high *= 2;
            }
            while (low <= high) {
                int mid = (low + high) / 2;
                double midXP = this.getTotalXpForLevel(mid);
                if (midXP > currentXp) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            return high;
        });
    }

    public double getFormulaValueForLevel(String formula, int level) {
        Double cached;
        Map<Integer, Double> levelMap = this.formulaCache.get(formula);
        if (levelMap == null) {
            levelMap = new ConcurrentHashMap<Integer, Double>();
            this.formulaCache.put(formula, levelMap);
        }
        if ((cached = levelMap.get(level)) != null) {
            return cached;
        }
        double result = this.formulas.get(formula).get().evaluate(new Placeholder[]{Placeholder.of((String)"level", (Number)level)});
        levelMap.put(level, result);
        return result;
    }

    @Override
    public double getRequiredXpForLevelUp(Player player) {
        return this.getXpForLevel(this.getUserData(player).getLevel() + 1);
    }

    public void correctCurrentXP(Player player) {
        LevelData data = this.getUserData(player);
        if (data.getCurrentXP() >= this.getRequiredXpForLevelUp(player)) {
            data.setCurrentXP(0.0);
            AuroraAPI.getLeaderboards().updateUser(AuroraAPI.getUserManager().getUser(player), new String[]{"levels"});
        }
        if (data.getLevel() > this.getLevelCap()) {
            data.setLevel(this.getLevelCap());
            data.setCurrentXP(0.0);
            AuroraAPI.getLeaderboards().updateUser(AuroraAPI.getUserManager().getUser(player), new String[]{"levels"});
        }
    }

    @EventHandler
    public void onUserLoaded(AuroraUserLoadedEvent event) {
        Player player = event.getUser().getPlayer();
        if (player == null) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            this.correctCurrentXP(player);
            this.rewardAutoCorrector.correctRewards(player);
        });
    }

    public RewardFactory getRewardFactory() {
        return this.rewardFactory;
    }

    public RewardAutoCorrector getRewardAutoCorrector() {
        return this.rewardAutoCorrector;
    }
}

