/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.libs.acf;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import gg.auroramc.levels.libs.acf.ACFPatterns;
import gg.auroramc.levels.libs.acf.ACFUtil;
import gg.auroramc.levels.libs.acf.BukkitCommandIssuer;
import gg.auroramc.levels.libs.acf.CommandCompletions;
import gg.auroramc.levels.libs.acf.LogLevel;
import gg.auroramc.levels.libs.acf.PaperCommandManager;
import gg.auroramc.levels.libs.acf.RootCommand;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

class PaperAsyncTabCompleteHandler
implements Listener {
    private final PaperCommandManager manager;

    PaperAsyncTabCompleteHandler(PaperCommandManager manager) {
        this.manager = manager;
        manager.log(LogLevel.INFO, "Enabled Asynchronous Tab Completion Support!");
    }

    @EventHandler(ignoreCancelled=true)
    public void onAsyncTabComplete(AsyncTabCompleteEvent event) {
        block5: {
            String buffer = event.getBuffer();
            if (!event.isCommand() && !buffer.startsWith("/") || buffer.indexOf(32) == -1) {
                return;
            }
            try {
                List<String> completions = this.getCompletions(buffer, event.getCompletions(), event.getSender(), true);
                if (completions != null) {
                    if (completions.size() == 1 && completions.get(0).equals("")) {
                        completions.set(0, " ");
                    }
                    event.setCompletions(completions);
                    event.setHandled(true);
                }
            }
            catch (Exception e) {
                if (e instanceof CommandCompletions.SyncCompletionRequired) break block5;
                throw e;
            }
        }
    }

    private List<String> getCompletions(String buffer, List<String> existingCompletions, CommandSender sender, boolean async) {
        String[] stringArray;
        String[] args = ACFPatterns.SPACE.split(buffer, -1);
        String commandLabel = PaperAsyncTabCompleteHandler.stripLeadingSlash(args[0]);
        if (args.length > 1) {
            stringArray = Arrays.copyOfRange(args, 1, args.length);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        args = stringArray;
        RootCommand rootCommand = this.manager.getRootCommand(commandLabel);
        if (rootCommand == null) {
            return null;
        }
        BukkitCommandIssuer issuer = this.manager.getCommandIssuer(sender);
        List<String> completions = rootCommand.getTabCompletions(issuer, commandLabel, args, false, async);
        return ACFUtil.preformOnImmutable(existingCompletions, list -> list.addAll(completions));
    }

    private static String stripLeadingSlash(String arg) {
        return arg.startsWith("/") ? arg.substring(1) : arg;
    }
}

