/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.menu;

import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.levels.ConcreteMatcher;
import gg.auroramc.aurora.api.levels.MatcherManager;
import gg.auroramc.aurora.api.menu.AuroraMenu;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.menu.MenuItem;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.config.menu.LevelMenuConfig;
import gg.auroramc.levels.config.menu.MilestoneMenuConfig;
import gg.auroramc.levels.leveler.PlayerLeveler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class MilestonesMenu {
    private static final NamespacedId menuId = NamespacedId.fromDefault((String)"milestones_menu");
    private final Player player;
    private int page = 0;
    private final AuroraLevels plugin;

    public MilestonesMenu(AuroraLevels plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void open() {
        this.createMenu().open();
    }

    private AuroraMenu createMenu() {
        PlayerLeveler leveler = this.plugin.getLeveler();
        MilestoneMenuConfig menuConfig = this.plugin.getConfigManager().getMilestoneMenuConfig();
        LevelMenuConfig lvlMenuConfig = this.plugin.getConfigManager().getLevelMenuConfig();
        AuroraMenu menu = new AuroraMenu(this.player, menuConfig.getTitle(), 9 * menuConfig.getRows(), false, menuId, new Placeholder[0]);
        if (menuConfig.getItems().getFiller().getEnabled().booleanValue()) {
            menu.addFiller(ItemBuilder.of((ItemConfig)menuConfig.getItems().getFiller().getItem()).slot(0).build(this.player).getItemStack());
        } else {
            menu.addFiller(ItemBuilder.filler((Material)Material.AIR));
        }
        long level = leveler.getUserData(this.player).getLevel();
        for (ItemConfig cItem : menuConfig.getCustomItems().values()) {
            menu.addItem(ItemBuilder.of((ItemConfig)cItem).build(this.player));
        }
        List<Map.Entry<Integer, ConcreteMatcher>> customLevels = this.getPage(this.page, menuConfig.getDisplayArea().size());
        for (int i = 0; i < menuConfig.getDisplayArea().size(); ++i) {
            Material defaultMaterial;
            ItemConfig itemConfig;
            Integer slot = menuConfig.getDisplayArea().get(i);
            if (customLevels.size() <= i) break;
            Map.Entry<Integer, ConcreteMatcher> milestone = customLevels.get(i);
            List rewards = milestone.getValue().computeRewards(milestone.getValue().getConfig().getLevel().intValue());
            Integer milestoneLevel = milestone.getKey();
            Map overrideItems = milestone.getValue().getConfig().getItem();
            if (milestoneLevel == 0) continue;
            if ((long)milestoneLevel.intValue() <= level) {
                itemConfig = lvlMenuConfig.getItems().getCompletedLevel().merge((ItemConfig)overrideItems.get("completed-level"));
                defaultMaterial = Material.LIME_STAINED_GLASS_PANE;
            } else {
                itemConfig = lvlMenuConfig.getItems().getLockedLevel().merge((ItemConfig)overrideItems.get("locked-level"));
                defaultMaterial = Material.RED_STAINED_GLASS_PANE;
            }
            List<Placeholder<?>> placeholders = leveler.getRewardFormulaPlaceholders(this.player, milestoneLevel);
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : itemConfig.getLore()) {
                if (line.equals("component:rewards")) {
                    LevelMenuConfig.DisplayComponent display = lvlMenuConfig.getDisplayComponents().get("rewards");
                    if (!rewards.isEmpty()) {
                        lore.add(display.getTitle());
                    }
                    for (Reward reward : rewards) {
                        lore.add(display.getLine().replace("{reward}", reward.getDisplay(this.player, placeholders)));
                    }
                    continue;
                }
                lore.add(line);
            }
            MenuItem item = ItemBuilder.of((ItemConfig)itemConfig).defaultMaterial(defaultMaterial).slot(slot.intValue()).placeholder(placeholders).loreCompute(() -> lore.stream().map(l -> Text.component((Player)this.player, (String)l, (List)placeholders)).toList()).build(this.player);
            menu.addItem(item);
        }
        int pageCount = this.getTotalPageCount(menuConfig.getDisplayArea().size());
        if (leveler.getLevelMatcher().getCustomMatchers().size() > menuConfig.getDisplayArea().size()) {
            List<Placeholder> placeholders = List.of(Placeholder.of((String)"{current}", (Number)(this.page + 1)), Placeholder.of((String)"{max}", (Number)(pageCount + 1)));
            menu.addItem(ItemBuilder.of((ItemConfig)menuConfig.getItems().getPreviousPage()).defaultSlot(48).placeholder(placeholders).build(this.player), e -> {
                if (this.page > 0) {
                    --this.page;
                    this.createMenu().open();
                }
            });
            menu.addItem(ItemBuilder.of((ItemConfig)menuConfig.getItems().getCurrentPage()).defaultSlot(49).placeholder(placeholders).build(this.player));
            menu.addItem(ItemBuilder.of((ItemConfig)menuConfig.getItems().getNextPage()).defaultSlot(50).placeholder(placeholders).build(this.player), e -> {
                if (this.page < pageCount) {
                    ++this.page;
                    this.createMenu().open();
                }
            });
        }
        return menu;
    }

    private List<Map.Entry<Integer, ConcreteMatcher>> getPage(int page, int pageSize) {
        return this.plugin.getLeveler().getLevelMatcher().getCustomMatchers().entrySet().stream().sorted(Map.Entry.comparingByKey()).skip((long)page * (long)pageSize).limit(pageSize).toList();
    }

    private int getTotalPageCount(int pageSize) {
        MatcherManager levelMatcher = this.plugin.getLeveler().getLevelMatcher();
        return (int)Math.ceil((double)levelMatcher.getCustomMatchers().size() / (double)pageSize) - 1;
    }

    public static NamespacedId getMenuId() {
        return menuId;
    }
}

