/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.menu;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.config.premade.ItemConfig;
import gg.auroramc.aurora.api.levels.ConcreteMatcher;
import gg.auroramc.aurora.api.levels.IntervalMatcher;
import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.menu.AuroraMenu;
import gg.auroramc.aurora.api.menu.ItemBuilder;
import gg.auroramc.aurora.api.menu.MenuItem;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.util.NamespacedId;
import gg.auroramc.aurora.expansions.leaderboard.LeaderboardExpansion;
import gg.auroramc.aurora.expansions.leaderboard.model.LbEntry;
import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.config.ConfigManager;
import gg.auroramc.levels.config.menu.LevelMenuConfig;
import gg.auroramc.levels.leveler.PlayerLeveler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class PaginatedLevelMenu {
    private int page = 0;
    private static final NamespacedId menuId = NamespacedId.fromDefault((String)"paginated_level_menu");
    private final Player player;
    private final AuroraLevels plugin;

    public PaginatedLevelMenu(AuroraLevels plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        int level = plugin.getLeveler().getUserData(player).getLevel();
        int pageSize = plugin.getConfigManager().getLevelMenuConfig().getLevelTrack().size();
        int totalPageCount = (int)Math.ceil((double)plugin.getLeveler().getLevelCap() / (double)pageSize) - 1;
        this.page = Math.min(level / pageSize, totalPageCount);
    }

    public void open() {
        this.createMenu().open();
    }

    private AuroraMenu createMenu() {
        PlayerLeveler leveler = this.plugin.getLeveler();
        ConfigManager cfg = this.plugin.getConfigManager();
        LevelMenuConfig menuConfig = cfg.getLevelMenuConfig();
        int level = leveler.getUserData(this.player).getLevel();
        int pageSize = menuConfig.getLevelTrack().size();
        int levelCap = this.plugin.getLeveler().getLevelCap();
        AuroraMenu menu = new AuroraMenu(this.player, menuConfig.getTitle(), 9 * menuConfig.getRows(), false, menuId, new Placeholder[0]);
        if (menuConfig.getItems().getFiller().getEnabled().booleanValue()) {
            menu.addFiller(ItemBuilder.of((ItemConfig)menuConfig.getItems().getFiller().getItem()).slot(0).build(this.player).getItemStack());
        } else {
            menu.addFiller(ItemBuilder.filler((Material)Material.AIR));
        }
        LeaderboardExpansion lbm = AuroraAPI.getLeaderboards();
        LbEntry lb = (LbEntry)AuroraAPI.getUser((UUID)this.player.getUniqueId()).getLeaderboardEntries().get("levels");
        Placeholder lbPositionPlaceholder = Placeholder.of((String)"{lb_position}", (String)(lb == null || lb.getPosition() == 0L ? lbm.getEmptyPlaceholder() : AuroraAPI.formatNumber((long)lb.getPosition())));
        Placeholder lbPositionPercentPlaceholder = Placeholder.of((String)"{lb_position_percent}", (String)(lb == null || lb.getPosition() == 0L ? lbm.getEmptyPlaceholder() : AuroraAPI.formatNumber((double)Math.min((double)lb.getPosition() / (double)Math.max(1L, AuroraAPI.getLeaderboards().getBoardSize("levels")) * 100.0, 100.0))));
        Placeholder lbBoardSizePlaceholder = Placeholder.of((String)"{lb_size}", (String)AuroraAPI.formatNumber((long)Math.max(AuroraAPI.getLeaderboards().getBoardSize("levels"), lb == null || lb.getPosition() == 0L ? (long)Bukkit.getOnlinePlayers().size() : Math.max(lb.getPosition(), (long)Bukkit.getOnlinePlayers().size()))));
        double totalCurrentXP = leveler.getXpForLevel(leveler.getUserData(this.player).getLevel()) + leveler.getUserData(this.player).getCurrentXP();
        for (ItemConfig customItem : menuConfig.getCustomItems().values()) {
            menu.addItem(ItemBuilder.of((ItemConfig)customItem).placeholder(Placeholder.of((String)"{level}", (Number)level)).placeholder(lbPositionPlaceholder).placeholder(lbPositionPercentPlaceholder).placeholder(lbBoardSizePlaceholder).placeholder(Placeholder.of((String)"{current}", (String)AuroraAPI.formatNumber((double)totalCurrentXP))).placeholder(Placeholder.of((String)"{current_short}", (String)AuroraAPI.formatNumberShort((double)totalCurrentXP))).build(this.player));
        }
        int pageStartLevel = this.page * pageSize + 1;
        int pageEndLevel = Math.min((this.page + 1) * pageSize, levelCap);
        int totalPageCount = (int)Math.ceil((double)levelCap / (double)pageSize) - 1;
        int iteratorLevel = pageStartLevel;
        for (Integer slot : menuConfig.getLevelTrack()) {
            Material defaultMaterial;
            ItemConfig itemConfig;
            LevelMatcher matcher = leveler.getLevelMatcher().getBestMatcher(iteratorLevel);
            List rewards = matcher.computeRewards(iteratorLevel);
            Map overrideItems = Map.of();
            if (matcher instanceof IntervalMatcher) {
                IntervalMatcher intervalMatcher = (IntervalMatcher)matcher;
                overrideItems = intervalMatcher.getConfig().getItem();
            } else if (matcher instanceof ConcreteMatcher) {
                ConcreteMatcher concreteMatcher = (ConcreteMatcher)matcher;
                overrideItems = concreteMatcher.getConfig().getItem();
            }
            if (iteratorLevel <= level) {
                itemConfig = menuConfig.getItems().getCompletedLevel().merge((ItemConfig)overrideItems.get("completed-level"));
                defaultMaterial = Material.LIME_STAINED_GLASS_PANE;
            } else if (iteratorLevel - 1 == level) {
                itemConfig = menuConfig.getItems().getNextLevel().merge((ItemConfig)overrideItems.get("next-level"));
                defaultMaterial = Material.YELLOW_STAINED_GLASS_PANE;
            } else {
                itemConfig = menuConfig.getItems().getLockedLevel().merge((ItemConfig)overrideItems.get("locked-level"));
                defaultMaterial = Material.RED_STAINED_GLASS_PANE;
            }
            List<Placeholder<?>> placeholders = leveler.getRewardFormulaPlaceholders(this.player, Math.min(iteratorLevel, leveler.getLevelCap()));
            placeholders.add(lbPositionPlaceholder);
            placeholders.add(lbPositionPercentPlaceholder);
            placeholders.add(lbBoardSizePlaceholder);
            if (iteratorLevel - 1 == level) {
                double currentXP = leveler.getUserData(this.player).getCurrentXP();
                double requiredXP = leveler.getRequiredXpForLevelUp(this.player);
                placeholders.add(Placeholder.of((String)"{current}", (String)AuroraAPI.formatNumber((double)currentXP)));
                placeholders.add(Placeholder.of((String)"{current_short}", (String)AuroraAPI.formatNumberShort((double)currentXP)));
                placeholders.add(Placeholder.of((String)"{required}", (String)AuroraAPI.formatNumber((double)requiredXP)));
                placeholders.add(Placeholder.of((String)"{required_short}", (String)AuroraAPI.formatNumberShort((double)requiredXP)));
                LevelMenuConfig.ProgressBar bar = menuConfig.getProgressBar();
                Integer pcs = bar.getLength();
                double completedPercent = currentXP / requiredXP;
                int completedPcs = Double.valueOf(Math.floor((double)pcs.intValue() * completedPercent)).intValue();
                int remainingPcs = pcs - completedPcs;
                placeholders.add(Placeholder.of((String)"{progressbar}", (String)(bar.getFilledCharacter().repeat(completedPcs) + bar.getUnfilledCharacter().repeat(remainingPcs) + "&r")));
            }
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : itemConfig.getLore()) {
                if (line.equals("component:rewards")) {
                    LevelMenuConfig.DisplayComponent display = menuConfig.getDisplayComponents().get("rewards");
                    if (!rewards.isEmpty()) {
                        lore.add(display.getTitle());
                    }
                    for (Reward reward : rewards) {
                        lore.add(display.getLine().replace("{reward}", reward.getDisplay(this.player, placeholders)));
                    }
                    continue;
                }
                lore.add(line);
            }
            MenuItem item = ItemBuilder.of((ItemConfig)itemConfig).defaultMaterial(defaultMaterial).slot(slot.intValue()).placeholder(placeholders).loreCompute(() -> lore.stream().map(l -> Text.component((Player)this.player, (String)l, (List)placeholders)).toList()).amount(menuConfig.getUseItemAmounts() != false && leveler.getLevelCap() <= 64 ? iteratorLevel : 1).build(this.player);
            menu.addItem(item);
            if (++iteratorLevel != pageEndLevel + 1) continue;
            break;
        }
        if (totalPageCount <= 0) {
            return menu;
        }
        List<Placeholder> placeholders = List.of(Placeholder.of((String)"{current}", (Number)(this.page + 1)), Placeholder.of((String)"{max}", (Number)(totalPageCount + 1)));
        menu.addItem(ItemBuilder.of((ItemConfig)menuConfig.getItems().getPreviousPage()).defaultSlot(48).placeholder(placeholders).build(this.player), e -> {
            if (this.page > 0) {
                --this.page;
                this.createMenu().open();
            }
        });
        menu.addItem(ItemBuilder.of((ItemConfig)menuConfig.getItems().getCurrentPage()).defaultSlot(49).placeholder(placeholders).build(this.player));
        menu.addItem(ItemBuilder.of((ItemConfig)menuConfig.getItems().getNextPage()).defaultSlot(50).placeholder(placeholders).build(this.player), e -> {
            if (this.page < totalPageCount) {
                ++this.page;
                this.createMenu().open();
            }
        });
        return menu;
    }

    public static NamespacedId getMenuId() {
        return menuId;
    }
}

