/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.placeholder;

import gg.auroramc.aurora.api.AuroraAPI;
import gg.auroramc.aurora.api.message.Placeholder;
import gg.auroramc.aurora.api.message.Text;
import gg.auroramc.aurora.api.placeholder.PlaceholderHandler;
import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.config.menu.LevelMenuConfig;
import gg.auroramc.levels.leveler.PlayerLeveler;
import gg.auroramc.levels.util.RomanNumber;
import java.util.List;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;

public class LevelPlaceholderHandler
implements PlaceholderHandler {
    private final AuroraLevels plugin;
    private final LegacyComponentSerializer serializer = LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().build();

    public LevelPlaceholderHandler(AuroraLevels plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "level";
    }

    public String onPlaceholderRequest(Player player, String[] args) {
        PlayerLeveler leveler = this.plugin.getLeveler();
        if (args.length > 0) {
            switch (args[0]) {
                case "xp": {
                    double xp = leveler.getUserData(player).getCurrentXP();
                    return this.getFormattedXP(args, xp);
                }
                case "xpnext": {
                    double xp = leveler.getRequiredXpForLevelUp(player);
                    return this.getFormattedXP(args, xp);
                }
                case "progressbar": {
                    double currentXP = leveler.getUserData(player).getCurrentXP();
                    double requiredXP = leveler.getRequiredXpForLevelUp(player);
                    LevelMenuConfig menuConfig = this.plugin.getConfigManager().getLevelMenuConfig();
                    LevelMenuConfig.ProgressBar bar = menuConfig.getProgressBar();
                    Integer pcs = bar.getLength();
                    double completedPercent = currentXP / requiredXP;
                    int completedPcs = Double.valueOf(Math.floor((double)pcs.intValue() * completedPercent)).intValue();
                    int remainingPcs = pcs - completedPcs;
                    String rawBar = bar.getFilledCharacter().repeat(completedPcs) + bar.getUnfilledCharacter().repeat(remainingPcs) + "&r";
                    return this.serializer.serialize(Text.component((String)rawBar, (Placeholder[])new Placeholder[0]));
                }
                case "icon": {
                    String level = String.valueOf(leveler.getUserData(player).getLevel());
                    StringBuilder placeholder = new StringBuilder(this.plugin.getConfigManager().getLevelConfig().getIconGenerator().getOrDefault(level, ""));
                    if (placeholder.isEmpty()) {
                        for (String c : level.split("")) {
                            String charIcon = this.plugin.getConfigManager().getLevelConfig().getIconGenerator().get(c);
                            if (charIcon == null) {
                                return null;
                            }
                            placeholder.append(charIcon);
                        }
                    }
                    return this.serializer.serialize(Text.component((Player)player, (String)placeholder.toString(), (Placeholder[])new Placeholder[0]));
                }
                case "roman": {
                    return RomanNumber.toRoman(leveler.getUserData(player).getLevel());
                }
            }
        }
        return String.valueOf(leveler.getUserData(player).getLevel());
    }

    private String getFormattedXP(String[] args, double xp) {
        if (args.length > 1 && args[1].equals("formatted")) {
            return AuroraAPI.formatNumber((double)xp);
        }
        if (args.length > 1 && args[1].equals("short")) {
            return AuroraAPI.formatNumberShort((double)xp);
        }
        return String.valueOf(xp);
    }

    public List<String> getPatterns() {
        return List.of("", "xp", "xp_formatted", "xp_short", "xpnext", "xpnext_formatted", "xpnext_short", "progressbar", "icon", "roman");
    }
}

