/*
 * Decompiled with CFR 0.152.
 */
package gg.auroramc.levels.reward.corrector;

import gg.auroramc.aurora.api.levels.LevelMatcher;
import gg.auroramc.aurora.api.reward.CommandReward;
import gg.auroramc.aurora.api.reward.Reward;
import gg.auroramc.aurora.api.reward.RewardCorrector;
import gg.auroramc.levels.AuroraLevels;
import gg.auroramc.levels.api.data.LevelData;
import gg.auroramc.levels.leveler.PlayerLeveler;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandCorrector
implements RewardCorrector {
    private final AuroraLevels plugin;

    public CommandCorrector(AuroraLevels plugin) {
        this.plugin = plugin;
    }

    public void correctRewards(Player player) {
        CompletableFuture.runAsync(() -> {
            PlayerLeveler leveler = this.plugin.getLeveler();
            LevelData data = leveler.getUserData(player);
            int level = data.getLevel();
            HashMap<Integer, CommandReward> rewards = new HashMap<Integer, CommandReward>();
            for (int i = 1; i < level + 1; ++i) {
                LevelMatcher matcher = leveler.getLevelMatcher().getBestMatcher(i);
                if (matcher == null) continue;
                for (Reward reward : matcher.computeRewards(i)) {
                    CommandReward commandReward;
                    if (!(reward instanceof CommandReward) || !(commandReward = (CommandReward)reward).shouldBeCorrected(player, (long)i)) continue;
                    rewards.put(i, commandReward);
                }
            }
            if (rewards.isEmpty()) {
                return;
            }
            Bukkit.getGlobalRegionScheduler().run((Plugin)this.plugin, task -> {
                rewards.forEach((lvl, reward) -> {
                    if (!player.isOnline()) {
                        return;
                    }
                    reward.execute(player, (long)lvl.intValue(), leveler.getRewardFormulaPlaceholders(player, (int)lvl));
                });
                AuroraLevels.logger().debug("Corrected %d command rewards for player %s".formatted(rewards.size(), player.getName()));
            });
        });
    }
}

