/*
 * Decompiled with CFR 0.152.
 */
package com.hezaerd.mixin;

import com.google.common.base.Strings;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2172;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_4717;
import net.minecraft.class_634;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4717.class})
public abstract class ChatInputSuggestorMixin {
    @Unique
    private static final Pattern COLON_PATTERN = Pattern.compile("(@)");
    @Unique
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    @Shadow
    @Final
    class_342 field_21599;
    @Shadow
    @Final
    private boolean field_21601;
    @Shadow
    @Final
    class_310 field_21597;
    @Shadow
    @Nullable
    private CompletableFuture<Suggestions> field_21611;

    @Shadow
    public abstract void method_23920(boolean var1);

    @Inject(method={"refresh"}, at={@At(value="TAIL")}, cancellable=true)
    public void onRefresh(CallbackInfo ci) {
        boolean hasSlash;
        String message = this.field_21599.method_1882();
        StringReader reader = new StringReader(message);
        boolean bl = hasSlash = reader.canRead() && reader.peek() == '/';
        if (hasSlash) {
            reader.skip();
        }
        boolean isCommand = this.field_21601 || hasSlash;
        int cursor = this.field_21599.method_1881();
        if (!isCommand) {
            String textUptoCursor = message.substring(0, cursor);
            int start = Math.max(this.getLastPattern(textUptoCursor, COLON_PATTERN) - 1, 0);
            int whitespace = this.getLastPattern(textUptoCursor, WHITESPACE_PATTERN);
            if (start < textUptoCursor.length() && start >= whitespace && textUptoCursor.charAt(start) == '@') {
                ArrayList playerNames = new ArrayList();
                class_634 networkHandler = this.field_21597.method_1562();
                if (networkHandler != null) {
                    networkHandler.method_2880().forEach(entry -> playerNames.add("@" + entry.method_2966().getName()));
                    this.field_21611 = class_2172.method_9265(playerNames, (SuggestionsBuilder)new SuggestionsBuilder(textUptoCursor, start));
                    this.field_21611.thenRun(() -> {
                        if (this.field_21611.isDone()) {
                            return;
                        }
                        this.method_23920(false);
                    });
                    ci.cancel();
                }
            }
        }
    }

    @Unique
    private int getLastPattern(String input, Pattern pattern) {
        if (Strings.isNullOrEmpty((String)input)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }
}

