/*
 * Decompiled with CFR 0.152.
 */
package com.hezaerd.utils;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;

public final class DesktopNotifier {
    private static boolean isSupported;

    public static void notify(String title, String message) {
        if (!isSupported) {
            return;
        }
        TrayIcon[] icons = SystemTray.getSystemTray().getTrayIcons();
        if (icons.length > 0) {
            icons[0].displayMessage(title, message, TrayIcon.MessageType.INFO);
        }
    }

    static {
        if (SystemTray.isSupported()) {
            isSupported = true;
            SystemTray tray = SystemTray.getSystemTray();
            Image img = Toolkit.getDefaultToolkit().createImage(DesktopNotifier.class.getResource("/assets/simplemention/icon.png"));
            TrayIcon trayIcon = new TrayIcon(img, "Simple Mention");
            trayIcon.setImageAutoSize(true);
            try {
                tray.add(trayIcon);
            }
            catch (AWTException e) {
                isSupported = false;
            }
        }
    }
}

