/*
 * Decompiled with CFR 0.152.
 */
package com.ashkiano.stackrefill;

import com.ashkiano.stackrefill.Metrics;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.JSONObject;

public class StackRefill
extends JavaPlugin
implements Listener,
CommandExecutor {
    private String permission;

    public void onEnable() {
        this.saveDefaultConfig();
        this.permission = this.getConfig().getString("permission", "stackrefill.use");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("stackrefill").setExecutor((CommandExecutor)this);
        Metrics metrics = new Metrics(this, 20835);
        this.checkForUpdates();
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.shouldRefill(event.getPlayer())) {
            this.refillStack(event.getPlayer().getInventory(), event.getItemInHand().getType());
        }
    }

    @EventHandler
    public void onItemConsume(PlayerItemConsumeEvent event) {
        if (this.shouldRefill(event.getPlayer())) {
            this.refillStack(event.getPlayer().getInventory(), event.getItem().getType());
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getItem() != null && event.getItem().getType() == Material.FIREWORK_ROCKET && this.shouldRefill(event.getPlayer())) {
            this.refillStack(event.getPlayer().getInventory(), Material.FIREWORK_ROCKET);
        }
    }

    private boolean shouldRefill(Player player) {
        if (!player.hasPermission(this.permission)) {
            return false;
        }
        FileConfiguration config = this.getConfig();
        List enabledPlayers = config.getStringList("enabledForPlayers");
        return enabledPlayers.contains(player.getUniqueId().toString());
    }

    private void refillStack(PlayerInventory inventory, Material itemType) {
        if (itemType == Material.RABBIT_STEW) {
            return;
        }
        if (itemType.name().endsWith("SHULKER_BOX")) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack;
            int j;
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() != itemType || item.getAmount() != 1) continue;
            if (itemType.isEdible()) {
                for (j = 9; j < 36; ++j) {
                    stack = inventory.getItem(j);
                    if (stack == null || !stack.getType().isEdible() || stack.getType() == itemType) continue;
                    inventory.setItem(i, stack);
                    inventory.clear(j);
                    return;
                }
                continue;
            }
            for (j = 9; j < 36; ++j) {
                stack = inventory.getItem(j);
                if (stack == null || stack.getType() != itemType) continue;
                inventory.setItem(i, stack);
                inventory.clear(j);
                return;
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        UUID playerUUID;
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(this.permission)) {
            player.sendMessage("You do not have permission to use this command.");
            return true;
        }
        FileConfiguration config = this.getConfig();
        List enabledPlayers = config.getStringList("enabledForPlayers");
        if (enabledPlayers.contains((playerUUID = player.getUniqueId()).toString())) {
            enabledPlayers.remove(playerUUID.toString());
            player.sendMessage("Stack refilling is turned off.");
        } else {
            enabledPlayers.add(playerUUID.toString());
            player.sendMessage("Stack refilling is turned on.");
        }
        config.set("enabledForPlayers", (Object)enabledPlayers);
        this.saveConfig();
        return true;
    }

    private void checkForUpdates() {
        try {
            String pluginName = this.getDescription().getName();
            URL url = new URL("https://plugins.ashkiano.com/version_check.php?plugin=" + pluginName);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                String jsonResponse = response.toString();
                JSONObject jsonObject = new JSONObject(jsonResponse);
                if (jsonObject.has("error")) {
                    this.getLogger().warning("Error when checking for updates: " + jsonObject.getString("error"));
                } else {
                    String latestVersion = jsonObject.getString("latest_version");
                    String currentVersion = this.getDescription().getVersion();
                    if (currentVersion.equals(latestVersion)) {
                        this.getLogger().info("This plugin is up to date!");
                    } else {
                        this.getLogger().warning("There is a newer version (" + latestVersion + ") available! Please update!");
                    }
                }
            } else {
                this.getLogger().warning("Failed to check for updates. Response code: " + responseCode);
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to check for updates. Error: " + e.getMessage());
        }
    }
}

