package blimbo.items;

import net.minecraft.class_10124;
import net.minecraft.class_10134;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4466;

public class BeeFunctions {

    // Helper builder for consumable items.
    // This method sets up the base properties for a consumable item.
    public static class_10124.class_10125 bumble() {
        return class_10124.method_62850()
                .method_62852(0.4F)
                .method_62853(class_1839.field_8946)
                .method_62855(class_3417.field_15075)
                .method_62856(false);
    }

    // All consumable components are defined here.
    public static class ConsumableComponents {
        public static final class_10124 BUMBLE;

        static {
            // Build the consumable component for the Bee Totem.
            BUMBLE = bumble()
                    .method_62854(new class_10134() {
                        @Override
                        public class_10135<? extends class_10134> method_62864() {
                            // This effect is not serializable, so we return null.
                            return null;
                        }

                        @Override
                        public boolean method_62866(class_1937 world, class_1799 stack, class_1309 user) {
                            // The if-check is crucial to ensure this code only runs on the server side.
                            if (!world.field_9236) {
                                // --- Apply status effects to the user ---
                                // Grant a regeneration effect.
                                user.method_6092(new class_1293(class_1294.field_5924, 200, 3));
                                // Remove the poison effect. Note: `StatusEffects.POISON` is the correct way to reference it.
                                user.method_6016(class_1294.field_5899);

                            // The if-check is crucial to ensure this code only runs on the server side.
                            // This prevents duplicate effects and potential desyncs.

                                // Cast the world to ServerWorld to use server-specific methods.
                                class_3218 serverWorld = (class_3218) world;

                                // Define the number of bees to spawn in the circle.
                                final int lightningCount = 100;
                                // Define the radius of the circle in blocks.
                                final double radius = 2;

                                // Loop to spawn multiple bbes bolts.
                                for (int i = 0; i < lightningCount; i++) {
                                    // Calculate the angle for each bees  to be spaced evenly in a circle.
                                    double angle = (250.0 / lightningCount) * i;
                                    double radians = Math.toRadians(angle);

                                    // Calculate the x and z coordinates for the new lightning bolt position
                                    // based on the player's position and the radius.
                                    double spawnX = user.method_23317() + radius * Math.sin(radians);
                                    double spawnZ = user.method_23321() + radius * Math.cos(radians);
                                    double spawnY = user.method_23318();

                                    // Create a new lightning bolt entity.
                                    class_4466 bee = class_1299.field_20346.method_5883(serverWorld, class_3730.field_16467);

                                    // Check if the entity was created successfully to prevent errors.
                                    if (bee != null) {
                                        // Set the exact position for the bees.
                                        bee.method_5808(
                                                spawnX,
                                                spawnY,
                                                spawnZ,
                                                user.method_36454(),
                                                user.method_36455()
                                        );

                                        // Add the lightning entity to the world.
                                        serverWorld.method_8649(bee);
                                    }
                                }
                            }
                            // Return true to indicate that the item was successfully consumed.
                            return true;
                        }
                    }).method_62851();
        }
    }
}