package blimbo.items;

import net.minecraft.class_10124;
import net.minecraft.class_10134;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3730;

public class ThunderFunctions {

    // Helper builder for consumable items.
    // This method sets up the base properties for a consumable item.
    public static class_10124.class_10125 thund() {
        return class_10124.method_62850()
                .method_62852(0.4F)
                .method_62853(class_1839.field_8946)
                .method_62855(class_3417.field_15075)
                .method_62856(false);
    }

    // All consumable components are defined here.
    public static class ConsumableComponents {
        public static final class_10124 TTOTEM;

        static {
            // Build the consumable component for the Thunder Totem.
            TTOTEM = thund()
                    .method_62854(new class_10134() {
                        @Override
                        public class_10135<? extends class_10134> method_62864() {
                            // This effect is not serializable, so we return null.
                            // This is expected for transient effects.
                            return null;
                        }

                        @Override
                        public boolean method_62866(class_1937 world, class_1799 stack, class_1309 user) {
                            // The if-check is crucial to ensure this code only runs on the server side.
                            // This prevents duplicate effects and potential desyncs.
                            if (!world.field_9236) {
                                // Cast the world to ServerWorld to use server-specific methods.
                                class_3218 serverWorld = (class_3218) world;

                                // Define the number of lightning bolts to spawn in the circle.
                                final int lightningCount = 36;
                                // Define the radius of the circle in blocks.
                                final double radius = 5;

                                // Loop to spawn multiple lightning bolts.
                                for (int i = 0; i < lightningCount; i++) {
                                    // Calculate the angle for each lightning bolt to be spaced evenly in a circle.
                                    double angle = (360.0 / lightningCount) * i;
                                    double radians = Math.toRadians(angle);

                                    // Calculate the x and z coordinates for the new lightning bolt position
                                    // based on the player's position and the radius.
                                    double spawnX = user.method_23317() + radius * Math.cos(radians);
                                    double spawnZ = user.method_23321() + radius * Math.sin(radians);
                                    double spawnY = user.method_23318();

                                    // Create a new lightning bolt entity.
                                    class_1538 lightning = class_1299.field_6112.method_5883(serverWorld, class_3730.field_16467);

                                    // Check if the entity was created successfully to prevent errors.
                                    if (lightning != null) {
                                        // Set the exact position for the lightning bolt.
                                        lightning.method_5808(
                                                spawnX,
                                                spawnY,
                                                spawnZ,
                                                user.method_36454(),
                                                user.method_36455()
                                        );

                                        // Add the lightning entity to the world.
                                        serverWorld.method_8649(lightning);
                                    }
                                }
                            }
                            // Return true to indicate that the item was successfully consumed.
                            return true;
                        }
                    })
                    .method_62851();
        }
    }
}