/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.block.entity.custom;

import com.cobblemon.khataly.mapkit.block.entity.ModBlockEntities;
import com.cobblemon.khataly.mapkit.config.HMConfig;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class UltraHolePortalEntity
extends class_2586 {
    private int lifetime;
    private int age;
    private String targetDimension;
    private double targetX;
    private double targetY;
    private double targetZ;
    private Runnable onRemove;
    private boolean growSoundPlayed = false;

    public UltraHolePortalEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.ULTRAHOLE_ROCK_BE, pos, state);
        this.targetDimension = HMConfig.ULTRAHOLE_SETTINGS.destinationDimension;
        this.targetX = HMConfig.ULTRAHOLE_SETTINGS.x;
        this.targetY = HMConfig.ULTRAHOLE_SETTINGS.y;
        this.targetZ = HMConfig.ULTRAHOLE_SETTINGS.z;
        this.lifetime = HMConfig.ULTRAHOLE_SETTINGS.durationTicks;
        this.age = 0;
    }

    public void setTarget(String dimension, double x, double y, double z) {
        this.targetDimension = dimension;
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.method_5431();
    }

    public void setOnRemove(Runnable onRemove) {
        this.onRemove = onRemove;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public boolean isGrowSoundPlayed() {
        return this.growSoundPlayed;
    }

    public void setGrowSoundPlayed(boolean played) {
        this.growSoundPlayed = played;
    }

    @Nullable
    public class_3218 getTargetWorld(MinecraftServer server) {
        if (server == null) {
            return null;
        }
        return server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)this.targetDimension)));
    }

    public void removePortal() {
        if (this.field_11863 != null) {
            this.field_11863.method_8501(this.field_11867, class_2246.field_10124.method_9564());
            if (this.onRemove != null) {
                this.onRemove.run();
            }
        }
    }

    public void tick() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        ++this.age;
        class_238 box = new class_238(this.field_11867).method_1009(0.2, 0.2, 0.2);
        List playersInside = this.field_11863.method_8390(class_3222.class, box, p -> true);
        for (class_3222 player : playersInside) {
            class_3218 targetWorld = this.getTargetWorld(player.method_5682());
            if (targetWorld == null) continue;
            double x = this.targetX;
            double y = this.targetY;
            double z = this.targetZ;
            if (targetWorld.method_27983().method_29177().toString().equals("minecraft:overworld")) {
                class_2338 spawnPos = player.method_26280();
                if (spawnPos == null) {
                    spawnPos = targetWorld.method_43126();
                }
                x = (double)spawnPos.method_10263() + 0.5;
                y = spawnPos.method_10264();
                z = (double)spawnPos.method_10260() + 0.5;
            }
            player.method_14251(targetWorld, x, y, z, player.method_36454(), player.method_36455());
            this.removePortal();
        }
        if (this.age >= this.lifetime) {
            this.removePortal();
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10582("targetDimension", this.targetDimension);
        nbt.method_10549("targetX", this.targetX);
        nbt.method_10549("targetY", this.targetY);
        nbt.method_10549("targetZ", this.targetZ);
        nbt.method_10569("lifetime", this.lifetime);
        nbt.method_10569("age", this.age);
        nbt.method_10556("growSoundPlayed", this.growSoundPlayed);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.targetDimension = nbt.method_10558("targetDimension");
        this.targetX = nbt.method_10574("targetX");
        this.targetY = nbt.method_10574("targetY");
        this.targetZ = nbt.method_10574("targetZ");
        this.lifetime = nbt.method_10550("lifetime");
        this.age = nbt.method_10550("age");
        this.growSoundPlayed = nbt.method_10577("growSoundPlayed");
    }
}

