/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.command.custom;

import com.cobblemon.khataly.mapkit.config.GrassZonesConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class GrassZoneCommands {
    public static void register(CommandDispatcher<class_2168> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"grasszone").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            int count = 0;
            block0: for (GrassZonesConfig.Zone z : GrassZonesConfig.getAll()) {
                ++count;
                src.method_9226(() -> class_2561.method_43470((String)("\u00a76\u2014 Zone \u00a7e" + String.valueOf(z.id()) + "\u00a76 \u2014")), false);
                src.method_9226(() -> class_2561.method_43470((String)(" \u00a77Dim:\u00a7f " + String.valueOf(z.worldKey().method_29177()) + " \u00a77Y:\u00a7f " + z.y())), false);
                src.method_9226(() -> class_2561.method_43470((String)(" \u00a77Area:\u00a7f [" + z.minX() + ", " + z.minZ() + "] \u2192 [" + z.maxX() + ", " + z.maxZ() + "]")), false);
                int shown = 0;
                if (z.spawns().isEmpty()) {
                    src.method_9226(() -> class_2561.method_43470((String)" \u00a77Spawns:\u00a7f (empty)"), false);
                    continue;
                }
                src.method_9226(() -> class_2561.method_43470((String)" \u00a77Spawns:\u00a7f"), false);
                for (GrassZonesConfig.SpawnEntry s : z.spawns()) {
                    src.method_9226(() -> class_2561.method_43470((String)(" \u2022 \u00a7a" + s.species + "\u00a77 lvl\u00a7f " + s.minLevel + "-" + s.maxLevel + " \u00a77w\u00a7f " + s.weight)), false);
                    if (++shown < 6) continue;
                    src.method_9226(() -> class_2561.method_43470((String)" \u2026"), false);
                    continue block0;
                }
            }
            int finalCount = count;
            src.method_9226(() -> class_2561.method_43470((String)("\u00a77Total zones: \u00a7f" + finalCount)), false);
            return 1;
        }))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            UUID zid;
            class_2168 src = (class_2168)ctx.getSource();
            String sid = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            try {
                zid = UUID.fromString(sid);
            }
            catch (IllegalArgumentException ex) {
                src.method_9226(() -> class_2561.method_43470((String)"\u00a7cInvalid ID."), false);
                return 1;
            }
            GrassZonesConfig.Zone zone = GrassZonesConfig.get(zid);
            if (zone == null) {
                src.method_9226(() -> class_2561.method_43470((String)"\u00a7cZone not found."), false);
                return 1;
            }
            MinecraftServer server = src.method_9211();
            class_3218 world = server.method_3847(zone.worldKey());
            if (world == null) {
                src.method_9226(() -> class_2561.method_43470((String)("\u00a7cDimension not loaded: " + String.valueOf(zone.worldKey().method_29177()))), false);
                return 1;
            }
            int removed = GrassZoneCommands.clearGrassInZone((class_1937)world, zone);
            boolean ok = GrassZonesConfig.removeZone(zid);
            src.method_9226(() -> class_2561.method_43470((String)((ok ? "\u00a7aZone removed. " : "\u00a7cRemoval error. ") + "\u00a77Grass removed: \u00a7f" + removed)), false);
            return 1;
        })))).then(class_2170.method_9247((String)"removehere").executes(ctx -> {
            class_2338 bp;
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 p = src.method_44023();
            if (p == null) {
                return 0;
            }
            class_5321 wk = p.method_37908().method_27983();
            List<GrassZonesConfig.Zone> zones = GrassZonesConfig.findAt((class_5321<class_1937>)wk, (bp = p.method_24515()).method_10263(), bp.method_10264(), bp.method_10260());
            if (zones.isEmpty()) {
                zones = GrassZonesConfig.findAt((class_5321<class_1937>)wk, bp.method_10263(), bp.method_10264() - 1, bp.method_10260());
            }
            if (zones.isEmpty()) {
                src.method_9226(() -> class_2561.method_43470((String)"\u00a77No zone here."), false);
                return 1;
            }
            GrassZonesConfig.Zone z = zones.getFirst();
            int removed = GrassZoneCommands.clearGrassInZone(p.method_37908(), z);
            boolean ok = GrassZonesConfig.removeZone(z.id());
            src.method_9226(() -> class_2561.method_43470((String)((ok ? "\u00a7aZone removed. " : "\u00a7cRemoval error. ") + "\u00a77Grass removed: \u00a7f" + removed)), false);
            return 1;
        })));
    }

    private static int clearGrassInZone(class_1937 world, GrassZonesConfig.Zone z) {
        int y = z.y();
        int removed = 0;
        class_2248 shortGrass = GrassZoneCommands.resolveShortGrass();
        for (int x = z.minX(); x <= z.maxX(); ++x) {
            for (int zed = z.minZ(); zed <= z.maxZ(); ++zed) {
                class_2338 pos = new class_2338(x, y, zed);
                class_2680 st = world.method_8320(pos);
                if (shortGrass != null && st.method_27852(shortGrass)) {
                    world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                    ++removed;
                    continue;
                }
                if (st.method_27852(class_2246.field_10214)) {
                    class_2756 half = (class_2756)st.method_11654((class_2769)class_2741.field_12533);
                    if (half == class_2756.field_12607) {
                        class_2338 up = pos.method_10084();
                        if (world.method_8320(up).method_27852(class_2246.field_10214)) {
                            world.method_8652(up, class_2246.field_10124.method_9564(), 3);
                        }
                        world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                    } else {
                        class_2338 down = pos.method_10074();
                        if (world.method_8320(down).method_27852(class_2246.field_10214)) {
                            world.method_8652(down, class_2246.field_10124.method_9564(), 3);
                        }
                        world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                    }
                    ++removed;
                    continue;
                }
                class_2680 below = world.method_8320(pos.method_10074());
                if (!below.method_27852(class_2246.field_10214)) continue;
                world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                world.method_8652(pos.method_10074(), class_2246.field_10124.method_9564(), 3);
                ++removed;
            }
        }
        return removed;
    }

    private static class_2248 resolveShortGrass() {
        class_2248 b = (class_2248)class_7923.field_41175.method_10223(class_2960.method_60655((String)"minecraft", (String)"short_grass"));
        if (b != class_2246.field_10124) {
            return b;
        }
        class_2248 legacy = (class_2248)class_7923.field_41175.method_10223(class_2960.method_60655((String)"minecraft", (String)"grass"));
        return legacy != class_2246.field_10124 ? legacy : null;
    }
}

