/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.khataly.mapkit.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class FlyTargetConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/cobblemonmapkit/flytargets.json");
    private static final Map<String, TargetInfo> targets = new HashMap<String, TargetInfo>();
    private static final int CURRENT_SCHEMA_VERSION = 1;

    public static boolean addTarget(String name, class_5321<class_1937> worldKey, class_2338 pos) {
        String key = FlyTargetConfig.normalizeKey(name);
        if (targets.containsKey(key)) {
            return false;
        }
        targets.put(key, new TargetInfo(worldKey, pos));
        FlyTargetConfig.save();
        return true;
    }

    public static boolean removeTarget(String name) {
        String key = FlyTargetConfig.normalizeKey(name);
        if (!targets.containsKey(key)) {
            return false;
        }
        targets.remove(key);
        FlyTargetConfig.save();
        return true;
    }

    public static TargetInfo getTarget(String name) {
        return targets.get(FlyTargetConfig.normalizeKey(name));
    }

    public static Map<String, TargetInfo> getAllTargets() {
        return Collections.unmodifiableMap(targets);
    }

    public static void reload() {
        FlyTargetConfig.load();
    }

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            FlyTargetConfig.logInfo("Config non trovata: creo file vuoto.");
            FlyTargetConfig.safeRewrite(Collections.emptyMap());
            return;
        }
        HashMap<String, TargetInfo> loaded = new HashMap<String, TargetInfo>();
        boolean filePulito = true;
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            if (data == null) {
                filePulito = false;
            } else {
                Integer ver = data.schemaVersion == null ? 1 : data.schemaVersion;
                if (!Objects.equals(ver, 1)) {
                    FlyTargetConfig.logWarn("schemaVersion " + ver + " differente da 1. Riscriver\u00f2 il file.");
                    filePulito = false;
                }
                if (data.targets == null) {
                    filePulito = false;
                } else {
                    for (FlyTargetData d : data.targets) {
                        if (!FlyTargetConfig.isEntryValid(d)) {
                            FlyTargetConfig.logWarn("Entry invalida, salto: " + FlyTargetConfig.safeName(d));
                            filePulito = false;
                            continue;
                        }
                        class_2960 id = class_2960.method_12829((String)d.worldKey);
                        if (id == null) {
                            FlyTargetConfig.logWarn("worldKey non valido: " + d.worldKey + " \u2014 salto entry " + d.name);
                            filePulito = false;
                            continue;
                        }
                        class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
                        class_2338 pos = new class_2338(d.x, d.y, d.z);
                        loaded.put(FlyTargetConfig.normalizeKey(d.name), new TargetInfo((class_5321<class_1937>)worldKey, pos));
                    }
                }
            }
        }
        catch (JsonParseException e) {
            FlyTargetConfig.logError("JSON malformato: " + e.getMessage(), e);
            filePulito = false;
        }
        catch (IOException e) {
            FlyTargetConfig.logError("Errore IO in lettura del file di config", e);
            filePulito = false;
        }
        if (!filePulito) {
            FlyTargetConfig.safeRewrite(loaded);
        } else {
            targets.clear();
            targets.putAll(loaded);
            FlyTargetConfig.logInfo("Loaded " + targets.size() + " fly targets.");
        }
    }

    public static void save() {
        try {
            File dir = CONFIG_FILE.getParentFile();
            if (dir != null && !dir.exists() && !dir.mkdirs()) {
                FlyTargetConfig.logWarn("Impossibile creare la directory di configurazione: " + dir.getAbsolutePath());
            }
            ConfigData data = new ConfigData();
            data.schemaVersion = 1;
            for (Map.Entry<String, TargetInfo> entry : targets.entrySet()) {
                String name = entry.getKey();
                TargetInfo info = entry.getValue();
                data.targets.add(new FlyTargetData(name, info.worldKey.method_29177().toString(), info.pos.method_10263(), info.pos.method_10264(), info.pos.method_10260()));
            }
            File temp = new File(CONFIG_FILE.getParent(), CONFIG_FILE.getName() + ".tmp");
            try (FileWriter writer = new FileWriter(temp);){
                GSON.toJson((Object)data, (Appendable)writer);
            }
            try {
                Files.move(temp.toPath(), CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException atomicNotSupported) {
                Files.move(temp.toPath(), CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            FlyTargetConfig.logError("Errore durante il salvataggio del file di config", e);
        }
    }

    private static boolean isEntryValid(FlyTargetData d) {
        if (d == null) {
            return false;
        }
        return d.name != null && !d.name.isBlank() && d.worldKey != null && !d.worldKey.isBlank() && d.y >= -2048 && d.y <= 4096;
    }

    private static void safeRewrite(Map<String, TargetInfo> validEntries) {
        try {
            File dir = CONFIG_FILE.getParentFile();
            if (dir != null && !dir.exists() && !dir.mkdirs()) {
                FlyTargetConfig.logWarn("Impossibile creare la directory di configurazione: " + dir.getAbsolutePath());
            }
            targets.clear();
            if (validEntries != null) {
                targets.putAll(validEntries);
            }
            FlyTargetConfig.save();
            FlyTargetConfig.logInfo("File rigenerato con " + targets.size() + " target validi.");
        }
        catch (Exception ex) {
            FlyTargetConfig.logError("Errore durante la riscrittura sicura del file di config", ex);
        }
    }

    private static String normalizeKey(String name) {
        return name == null ? "" : name.toLowerCase(Locale.ROOT);
    }

    private static String safeName(FlyTargetData d) {
        return d == null ? "<null>" : (d.name == null ? "<no-name>" : d.name);
    }

    private static void logInfo(String msg) {
        System.out.println("[FlyTargetConfig] " + msg);
    }

    private static void logWarn(String msg) {
        System.out.println("[FlyTargetConfig][WARN] " + msg);
    }

    private static void logError(String msg) {
        System.err.println("[FlyTargetConfig][ERROR] " + msg);
    }

    private static void logError(String msg, Throwable t) {
        System.err.println("[FlyTargetConfig][ERROR] " + msg);
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            System.err.println(sw.toString());
        }
    }

    public static class TargetInfo {
        public final class_5321<class_1937> worldKey;
        public final class_2338 pos;

        public TargetInfo(class_5321<class_1937> worldKey, class_2338 pos) {
            this.worldKey = worldKey;
            this.pos = pos;
        }
    }

    private static class ConfigData {
        Integer schemaVersion;
        List<FlyTargetData> targets = new ArrayList<FlyTargetData>();

        private ConfigData() {
        }
    }

    private static class FlyTargetData {
        String name;
        String worldKey;
        int x;
        int y;
        int z;

        FlyTargetData(String name, String worldKey, int x, int y, int z) {
            this.name = name;
            this.worldKey = worldKey;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

